/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.validators;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.File;
import org.apache.syncope.installer.validators.AbstractValidator;

public class ArchetypeValidator
extends AbstractValidator {
    private StringBuilder error;

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        String mavenDir = installData.getVariable("mvn.directory");
        String mavenGroupId = installData.getVariable("mvn.groupid");
        String mavenArtifactId = installData.getVariable("mvn.artifactid");
        String mavenSecretKey = installData.getVariable("mvn.secretkey");
        String mavenAnonymousKey = installData.getVariable("mvn.anonymous.key");
        String mavenLogDirectory = installData.getVariable("mvn.log.directory");
        String mavenBundleDirectory = installData.getVariable("mvn.bundle.directory");
        boolean verified = true;
        this.error = new StringBuilder("Required fields:\n");
        if (this.isEmpty(mavenDir)) {
            this.error.append("Maven home directory\n");
            verified = false;
        } else if (!new File(mavenDir + "/bin/mvn").exists()) {
            this.error.append("Maven home directory not valid, check it please...\n");
            verified = false;
        }
        if (this.isEmpty(mavenGroupId)) {
            this.error.append("GroupID\n");
            verified = false;
        }
        if (this.isEmpty(mavenArtifactId)) {
            this.error.append("ArtifactID\n");
            verified = false;
        }
        if (this.isEmpty(mavenSecretKey)) {
            this.error.append("SecretKey\n");
            verified = false;
        }
        if (this.isEmpty(mavenAnonymousKey)) {
            this.error.append("AnonymousKey\n");
            verified = false;
        }
        if (this.isEmpty(mavenLogDirectory)) {
            this.error.append("Logs directory\n");
            verified = false;
        }
        if (this.isEmpty(mavenBundleDirectory)) {
            this.error.append("Bundles directory\n");
            verified = false;
        }
        return verified ? DataValidator.Status.OK : DataValidator.Status.ERROR;
    }

    @Override
    public String getErrorMessageId() {
        return this.error.toString();
    }

    @Override
    public String getWarningMessageId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getDefaultAnswer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

