/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.utilities;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.util.Date;
import org.apache.syncope.installer.utilities.FileSystemUtils;

public class InstallLog {
    private static InstallLog installLog = null;
    private final File log;
    private final FileSystemUtils fileSystemUtils;
    private final String fileAbsolutePath;

    private InstallLog(String installPath, AbstractUIProcessHandler handler) {
        this.fileAbsolutePath = installPath + "/install.log";
        this.log = new File(this.fileAbsolutePath);
        this.fileSystemUtils = new FileSystemUtils(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstallLog initialize(String installPath, AbstractUIProcessHandler handler) {
        Class<InstallLog> clazz = InstallLog.class;
        synchronized (InstallLog.class) {
            if (installLog == null) {
                installLog = new InstallLog(installPath, handler);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return installLog;
        }
    }

    public static InstallLog getInstance() {
        return installLog;
    }

    public void error(String msg) {
        this.writeToFile("Error", msg);
    }

    public void info(String msg) {
        this.writeToFile("Info", msg);
    }

    public String getFileAbsolutePath() {
        return this.fileAbsolutePath;
    }

    private void writeToFile(String what, String msg) {
        this.fileSystemUtils.appendToFile(this.log, new Date() + " | " + what + ": " + msg);
    }
}

