/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.utilities;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.w3c.dom.Document;

public class FileSystemUtils {
    private final AbstractUIProcessHandler handler;

    public FileSystemUtils(AbstractUIProcessHandler handler) {
        this.handler = handler;
    }

    public void createDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public void exec(String cmd, String path) {
        try {
            this.handler.logOutput("Executing " + cmd, true);
            ProcessBuilder builder = new ProcessBuilder(cmd.split(" "));
            if (path != null && !path.isEmpty()) {
                builder.directory(new File(path));
            }
            Process process = builder.start();
            this.readResponse(process.getInputStream());
        }
        catch (IOException ex) {
            String errorMessage = "Error executing " + cmd + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }

    private void readResponse(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        while (line != null) {
            line = reader.readLine();
            String content = line == null ? "" : line;
            this.handler.logOutput(content, false);
            InstallLog.getInstance().info(content);
        }
        inputStream.close();
    }

    public void writeToFile(File file, String content) {
        try {
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        catch (IOException ex) {
            String errorMessage = "Error writing file " + file.getAbsolutePath() + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }

    public void appendToFile(File file, String content) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            out.println(content);
            out.close();
        }
        catch (IOException ex) {
            String errorMessage = "Error writing file " + file.getAbsolutePath() + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(Document doc, OutputStream out) throws IOException, TransformerException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static void delete(File file) {
        FileUtils.deleteQuietly(file);
    }
}

