/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.processes;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import org.apache.syncope.installer.enums.DBs;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;

public class PersistenceProcess {
    private String installPath;
    private String artifactId;
    private DBs dbSelected;
    private String persistenceUrl;
    private String persistenceUser;
    private String persistencePassword;
    private boolean mysqlInnoDB;
    private String oracleTableSpace;

    public void run(AbstractUIProcessHandler handler, String[] args) {
        this.installPath = args[0];
        this.artifactId = args[1];
        this.dbSelected = DBs.fromDbName(args[2]);
        this.persistenceUrl = args[3];
        this.persistenceUser = args[4];
        this.persistencePassword = args[5];
        this.mysqlInnoDB = Boolean.valueOf(args[6]);
        this.oracleTableSpace = args[7];
        FileSystemUtils fileSystemUtils = new FileSystemUtils(handler);
        StringBuilder persistenceProperties = new StringBuilder("# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\n");
        handler.logOutput("Configure persistence file according to " + (Object)((Object)this.dbSelected) + " properties", true);
        InstallLog.getInstance().info("Configure persistence file according to " + (Object)((Object)this.dbSelected) + " properties");
        switch (this.dbSelected) {
            case POSTGRES: {
                persistenceProperties.append(String.format("jpa.driverClassName=org.postgresql.Driver\njpa.url=%s\njpa.username=%s\njpa.password=%s\njpa.dialect=org.apache.openjpa.jdbc.sql.PostgresDictionary\njpa.pool.validationQuery=SELECT 1\nquartz.jobstore=org.quartz.impl.jdbcjobstore.PostgreSQLDelegate\nquartz.sql=tables_postgres.sql\naudit.sql=audit.sql\ndatabase.schema=\n", this.persistenceUrl, this.persistenceUser, this.persistencePassword));
                break;
            }
            case MYSQL: {
                persistenceProperties.append(String.format("jpa.driverClassName=com.mysql.jdbc.Driver\njpa.url=%s\njpa.username=%s\njpa.password=%s\njpa.dialect=org.apache.openjpa.jdbc.sql.MySQLDictionary\njpa.pool.validationQuery=SELECT 1\nquartz.jobstore=org.quartz.impl.jdbcjobstore.StdJDBCDelegate\naudit.sql=audit.sql\ndatabase.schema=\n", this.persistenceUrl, this.persistenceUser, this.persistencePassword));
                if (this.mysqlInnoDB) {
                    persistenceProperties.append("quartz.sql=tables_mysql_innodb.sql");
                    break;
                }
                persistenceProperties.append("quartz.sql=tables_mysql.sql");
                break;
            }
            case MARIADB: {
                persistenceProperties.append(String.format("jpa.driverClassName=org.mariadb.jdbc.Driver\njpa.url=%s\njpa.username=%s\njpa.password=%s\njpa.dialect=org.apache.openjpa.jdbc.sql.MariaDBDictionary\njpa.pool.validationQuery=SELECT 1\nquartz.jobstore=org.quartz.impl.jdbcjobstore.StdJDBCDelegate\nquartz.sql=tables_mariadb.sql\naudit.sql=audit.sql\ndatabase.schema=\n", this.persistenceUrl, this.persistenceUser, this.persistencePassword));
                break;
            }
            case ORACLE: {
                persistenceProperties.append(String.format("jpa.driverClassName=oracle.jdbc.OracleDriver\njpa.url=%s\njpa.username=%s\njpa.password=%s\njpa.dialect=org.apache.openjpa.jdbc.sql.OracleDictionary\njpa.pool.validationQuery=SELECT 1\nquartz.jobstore=org.quartz.impl.jdbcjobstore.oracle.OracleDelegate\nquartz.sql=tables_oracle.sql\naudit.sql=audit.sql\ndatabase.schema=%s\n", this.persistenceUrl, this.persistenceUser, this.persistencePassword, this.oracleTableSpace));
                this.writeOrmFile(fileSystemUtils, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\nLicensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n\"License\"); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n  http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing,\nsoftware distributed under the License is distributed on an\n\"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, either express or implied.  See the License for the\nspecific language governing permissions and limitations\nunder the License.\n\n-->\n<entity-mappings  xmlns=\"http://java.sun.com/xml/ns/persistence/orm\"\n                  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n                  xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence/orm \n                                      http://java.sun.com/xml/ns/persistence/orm_2_0.xsd\"\n                  version=\"2.0\">\n\n  <table-generator name=\"SEQ_UAttrValue\" pk-column-value=\"SEQ_UAttrValue\" initial-value=\"100\"/>\n  <table-generator name=\"SEQ_RAttrValue\" pk-column-value=\"SEQ_RAttrValue\" initial-value=\"100\"/>\n  <table-generator name=\"SEQ_MAttrValue\" pk-column-value=\"SEQ_MAttrValue\" initial-value=\"100\"/>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.SyncopeUser\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_SyncopeUser\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_SyncopeUser\" pk-column-value=\"SEQ_SyncopeUser\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.SyncopeRole\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_SyncopeRole\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_SyncopeRole\" pk-column-value=\"SEQ_SyncopeRole\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.Membership\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Membership\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Membership\" pk-column-value=\"SEQ_Membership\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UMapping\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UMapping\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_UMapping\" pk-column-value=\"SEQ_UMapping\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RMapping\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RMapping\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_RMapping\" pk-column-value=\"SEQ_RMapping\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UMappingItem\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UMappingItem\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_UMappingItem\" pk-column-value=\"SEQ_UMappingItem\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RMappingItem\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RMappingItem\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_RMappingItem\" pk-column-value=\"SEQ_RMappingItem\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.ConnInstance\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_ConnInstance\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_ConnInstance\" pk-column-value=\"SEQ_ConnInstance\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UAttr\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UAttr\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_UAttr\" pk-column-value=\"SEQ_UAttr\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RAttr\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RAttr\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_RAttr\" pk-column-value=\"SEQ_RAttr\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.MAttr\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_MAttr\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_MAttr\" pk-column-value=\"SEQ_MAttr\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n    \n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UAttrValue\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UAttrUniqueValue\">\n    <table>\n      <unique-constraint>\n        <column-name>booleanValue</column-name>\n        <column-name>dateValue</column-name>\n        <column-name>stringValue</column-name>\n        <column-name>doubleValue</column-name>\n        <column-name>longValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n    </table>\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RAttrValue\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RAttrUniqueValue\">\n    <table>\n      <unique-constraint>\n        <column-name>booleanValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>dateValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>stringValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>doubleValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>longValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n    </table>\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.MAttrValue\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_MAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.MAttrUniqueValue\">\n    <table>\n      <unique-constraint>\n        <column-name>booleanValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>dateValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>stringValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>doubleValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>longValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n    </table>\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_MAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.Task\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Task\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Task\" pk-column-value=\"SEQ_Task\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.TaskExec\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_TaskExec\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_TaskExec\" pk-column-value=\"SEQ_TaskExec\" initial-value=\"10\"/>\n      </id>\n    </attributes>\n  </entity>\n    \n  <entity class=\"org.apache.syncope.core.persistence.beans.Policy\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Policy\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Policy\" pk-column-value=\"SEQ_Policy\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.Report\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Report\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Report\" pk-column-value=\"SEQ_Report\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.ReportExec\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_ReportExec\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_ReportExec\" pk-column-value=\"SEQ_ReportExec\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.ReportletConfInstance\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_ReportletConfInstance\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_ReportletConfInstance\" pk-column-value=\"SEQ_ReportletConfInstance\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.Notification\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Notification\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Notification\" pk-column-value=\"SEQ_Notification\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n</entity-mappings>");
                break;
            }
            case SQLSERVER: {
                persistenceProperties.append(String.format("jpa.driverClassName=com.microsoft.sqlserver.jdbc.SQLServerDriver\njpa.url=%s\njpa.username=%s\njpa.password=%s\njpa.dialect=org.apache.openjpa.jdbc.sql.SQLServerDictionary\nquartz.jobstore=org.quartz.impl.jdbcjobstore.MSSQLDelegate\nquartz.sql=tables_sqlServer.sql\naudit.sql=audit.sql\ndatabase.schema=\n", this.persistenceUrl, this.persistenceUser, this.persistencePassword));
                this.writeOrmFile(fileSystemUtils, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\nLicensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n\"License\"); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n  http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing,\nsoftware distributed under the License is distributed on an\n\"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, either express or implied.  See the License for the\nspecific language governing permissions and limitations\nunder the License.\n\n-->\n<entity-mappings  xmlns=\"http://java.sun.com/xml/ns/persistence/orm\"\n                  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n                  xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence/orm \n                                      http://java.sun.com/xml/ns/persistence/orm_2_0.xsd\"\n                  version=\"2.0\">\n\n  <table-generator name=\"SEQ_UAttrValue\" pk-column-value=\"SEQ_UAttrValue\" initial-value=\"100\"/>\n  <table-generator name=\"SEQ_RAttrValue\" pk-column-value=\"SEQ_RAttrValue\" initial-value=\"100\"/>\n  <table-generator name=\"SEQ_MAttrValue\" pk-column-value=\"SEQ_MAttrValue\" initial-value=\"100\"/>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.SyncopeUser\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_SyncopeUser\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_SyncopeUser\" pk-column-value=\"SEQ_SyncopeUser\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.SyncopeRole\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_SyncopeRole\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_SyncopeRole\" pk-column-value=\"SEQ_SyncopeRole\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.Membership\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Membership\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Membership\" pk-column-value=\"SEQ_Membership\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UMapping\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UMapping\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_UMapping\" pk-column-value=\"SEQ_UMapping\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RMapping\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RMapping\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_RMapping\" pk-column-value=\"SEQ_RMapping\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UMappingItem\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UMappingItem\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_UMappingItem\" pk-column-value=\"SEQ_UMappingItem\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RMappingItem\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RMappingItem\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_RMappingItem\" pk-column-value=\"SEQ_RMappingItem\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.ConnInstance\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_ConnInstance\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_ConnInstance\" pk-column-value=\"SEQ_ConnInstance\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UAttr\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UAttr\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_UAttr\" pk-column-value=\"SEQ_UAttr\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RAttr\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RAttr\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_RAttr\" pk-column-value=\"SEQ_RAttr\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.MAttr\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_MAttr\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_MAttr\" pk-column-value=\"SEQ_MAttr\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n    \n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UAttrValue\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.user.UAttrUniqueValue\">\n    <table>\n      <unique-constraint>\n        <column-name>booleanValue</column-name>\n        <column-name>dateValue</column-name>\n        <column-name>stringValue</column-name>\n        <column-name>doubleValue</column-name>\n        <column-name>longValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n    </table>\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_UAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RAttrValue\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.role.RAttrUniqueValue\">\n    <table>\n      <unique-constraint>\n        <column-name>booleanValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>dateValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>stringValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>doubleValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>longValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n    </table>\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_RAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.MAttrValue\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_MAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.membership.MAttrUniqueValue\">\n    <table>\n      <unique-constraint>\n        <column-name>booleanValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>dateValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>stringValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>doubleValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n      <unique-constraint>\n        <column-name>longValue</column-name>\n        <column-name>schema_name</column-name>\n      </unique-constraint>\n    </table>\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_MAttrValue\" strategy=\"TABLE\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.Task\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Task\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Task\" pk-column-value=\"SEQ_Task\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.TaskExec\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_TaskExec\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_TaskExec\" pk-column-value=\"SEQ_TaskExec\" initial-value=\"10\"/>\n      </id>\n    </attributes>\n  </entity>\n    \n  <entity class=\"org.apache.syncope.core.persistence.beans.Policy\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Policy\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Policy\" pk-column-value=\"SEQ_Policy\" initial-value=\"1000\"/>\n      </id>\n    </attributes>\n  </entity>\n\n  <entity class=\"org.apache.syncope.core.persistence.beans.Report\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Report\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Report\" pk-column-value=\"SEQ_Report\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.ReportExec\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_ReportExec\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_ReportExec\" pk-column-value=\"SEQ_ReportExec\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.ReportletConfInstance\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_ReportletConfInstance\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_ReportletConfInstance\" pk-column-value=\"SEQ_ReportletConfInstance\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n  <entity class=\"org.apache.syncope.core.persistence.beans.Notification\">\n    <attributes>\n      <id name=\"id\">\n        <generated-value generator=\"SEQ_Notification\" strategy=\"TABLE\"/>\n        <table-generator name=\"SEQ_Notification\" pk-column-value=\"SEQ_Notification\" initial-value=\"100\"/>\n      </id>\n    </attributes>\n  </entity>\n</entity-mappings>");
            }
        }
        fileSystemUtils.writeToFile(new File(this.installPath + "/" + this.artifactId + "/core/src/main/resources/persistence.properties"), persistenceProperties.toString());
    }

    private void writeOrmFile(FileSystemUtils fileSystemUtils, String content) {
        fileSystemUtils.createDirectory(this.installPath + File.separator + this.artifactId + "core/src/main/resources/META-INF");
        fileSystemUtils.writeToFile(new File(this.installPath + File.separator + this.artifactId + "core/src/main/resources/META-INF/orm.xml"), content);
    }
}

