/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.processes;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.syncope.installer.containers.Glassfish;
import org.apache.syncope.installer.containers.Tomcat;
import org.apache.syncope.installer.containers.jboss.JBoss;
import org.apache.syncope.installer.enums.Containers;
import org.apache.syncope.installer.files.CoreWebXml;
import org.apache.syncope.installer.files.GlassfishCoreWebXml;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.apache.syncope.installer.utilities.MavenUtils;
import org.xml.sax.SAXException;

public class ContainerProcess {
    private String installPath;
    private String mavenDir;
    private String artifactId;
    private String tomcatUser;
    private String tomcatPassword;
    private boolean tomcatSsl;
    private String tomcatHost;
    private String tomcatPort;
    private String glassfishDir;
    private String confDirectory;
    private String logsDirectory;
    private String bundlesDirectory;
    private boolean withDataSource;
    private boolean jbossSsl;
    private String jbossHost;
    private String jbossPort;
    private String jbossJdbcModuleName;
    private String jbossAdminUsername;
    private String jbossAdminPassword;
    private boolean isProxyEnabled;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPwd;
    private boolean mavenProxyAutoconf;

    public void run(AbstractUIProcessHandler handler, String[] args) {
        String emittedError;
        StringBuilder messageError;
        this.installPath = args[0];
        this.mavenDir = args[1];
        this.artifactId = args[2];
        Containers selectedContainer = Containers.fromContainerName(args[3]);
        this.tomcatSsl = Boolean.valueOf(args[4]);
        this.tomcatHost = args[5];
        this.tomcatPort = args[6];
        this.tomcatUser = args[7];
        this.tomcatPassword = args[8];
        this.glassfishDir = args[9];
        this.confDirectory = args[10];
        this.logsDirectory = args[11];
        this.bundlesDirectory = args[12];
        this.withDataSource = Boolean.valueOf(args[13]);
        this.jbossSsl = Boolean.valueOf(args[14]);
        this.jbossHost = args[15];
        this.jbossPort = args[16];
        this.jbossJdbcModuleName = args[17];
        this.jbossAdminUsername = args[18];
        this.jbossAdminPassword = args[19];
        this.isProxyEnabled = Boolean.valueOf(args[20]);
        this.proxyHost = args[21];
        this.proxyPort = args[22];
        this.proxyUser = args[23];
        this.proxyPwd = args[24];
        this.mavenProxyAutoconf = Boolean.valueOf(args[25]);
        FileSystemUtils fileSystemUtils = new FileSystemUtils(handler);
        handler.logOutput("Configure web.xml file according to " + (Object)((Object)selectedContainer) + " properties", true);
        InstallLog.getInstance().info("Configure web.xml file according to " + (Object)((Object)selectedContainer) + " properties");
        if (this.withDataSource) {
            fileSystemUtils.writeToFile(new File(this.installPath + "/" + this.artifactId + "/core/src/main/webapp/WEB-INF/web.xml"), CoreWebXml.withDataSource());
            switch (selectedContainer) {
                case JBOSS: {
                    fileSystemUtils.writeToFile(new File(this.installPath + "/" + this.artifactId + "/core/src/main/webapp/WEB-INF/web.xml"), CoreWebXml.withDataSourceForJBoss());
                    fileSystemUtils.writeToFile(new File(this.installPath + "/" + this.artifactId + "/core/src/main/resources/persistenceContextEMFactory.xml"), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\nLicensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n\"License\"); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n  http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing,\nsoftware distributed under the License is distributed on an\n\"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, either express or implied.  See the License for the\nspecific language governing permissions and limitations\nunder the License.\n-->\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       xsi:schemaLocation=\"http://www.springframework.org/schema/beans\n       http://www.springframework.org/schema/beans/spring-beans.xsd\">\n\n  <bean id=\"entityManagerFactory\"\n        class=\"org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean\">\n    <property name=\"persistenceXmlLocation\" value=\"classpath*:META-INF/spring-persistence.xml\"/>\n    <property name=\"persistenceUnitName\" value=\"syncopePersistenceUnit\"/>\n    <property name=\"dataSource\" ref=\"dataSource\"/>\n    <property name=\"jpaVendorAdapter\">\n      <bean class=\"org.springframework.orm.jpa.vendor.OpenJpaVendorAdapter\">\n        <property name=\"showSql\" value=\"false\"/>\n        <property name=\"generateDdl\" value=\"true\"/>\n        <property name=\"databasePlatform\" value=\"${jpa.dialect}\"/>\n      </bean>\n    </property>\n    <property name=\"jpaPropertyMap\">\n      <map>\n        <!--<entry key=\"openjpa.Log\" value=\"SQL=TRACE\"/>\n        <entry key=\"openjpa.ConnectionFactoryProperties\" value=\"PrettyPrint=true, PrettyPrintLineLength=80\"/>-->\n                \n        <entry key=\"openjpa.NontransactionalWrite\" value=\"false\"/>\n        <entry key=\"openjpa.AutoDetach\" value=\"close, commit, nontx-read, rollback\"/>\n\n        <entry key=\"openjpa.jdbc.SchemaFactory\" value=\"native(ForeignKeys=true)\"/>\n        <entry key=\"openjpa.jdbc.MappingDefaults\" value=\"ForeignKeyDeleteAction=restrict, JoinForeignKeyDeleteAction=restrict\"/>\n                \n        <entry key=\"openjpa.ReadLockLevel\" value=\"none\"/>\n        <entry key=\"openjpa.WriteLockLevel\" value=\"write\"/>\n        <entry key=\"openjpa.LockTimeout\" value=\"30000\"/>\n                                \n        <entry key=\"openjpa.DataCache\" value=\"true\" />\n        <entry key=\"openjpa.QueryCache\" value=\"true\"/>\n        <entry key=\"openjpa.RemoteCommitProvider\" value=\"sjvm\"/>\n        \n        <entry key=\"openjpa.MetaDataFactory\" value=\"jpa(URLs=vfs:/content/${project.build.finalName}.war/WEB-INF/classes/, Resources=META-INF/orm.xml)\"/>\n      </map>\n    </property>\n  </bean>\n\n</beans>");
                    fileSystemUtils.writeToFile(new File(this.installPath + "/" + this.artifactId + "/core/src/main/webapp/WEB-INF/jboss-deployment-structure.xml"), String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\nLicensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n\"License\"); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n       http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing,\nsoftware distributed under the License is distributed on an\n\"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, either express or implied.  See the License for the\nspecific language governing permissions and limitations\nunder the License.\n\n-->\n<jboss-deployment-structure xmlns=\"urn:jboss:deployment-structure:1.0\">\n  <deployment>\n    <dependencies>\n      <module name=\"org.apache.xalan\"/>\n      <module name=\"%s\"/>\n    </dependencies>\n    <exclusions>\n      <module name=\"org.hibernate\"/>\n      <module name=\"org.slf4j\"/>\n      <module name=\"org.slf4j.impl\"/>\n    </exclusions>\n  </deployment>\n</jboss-deployment-structure>", this.jbossJdbcModuleName));
                    break;
                }
                case GLASSFISH: {
                    fileSystemUtils.writeToFile(new File(this.installPath + "/" + this.artifactId + "/core/src/main/webapp/WEB-INF/glassfish-web.xml"), GlassfishCoreWebXml.withDataSource());
                }
            }
        }
        MavenUtils mavenUtils = new MavenUtils(this.mavenDir, handler);
        File customMavenProxySettings = null;
        try {
            if (this.isProxyEnabled && this.mavenProxyAutoconf) {
                customMavenProxySettings = MavenUtils.createSettingsWithProxy(this.installPath, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPwd);
            }
        }
        catch (IOException ex) {
            messageError = new StringBuilder("I/O error during creation of Maven custom settings.xml");
            emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        catch (ParserConfigurationException ex) {
            messageError = new StringBuilder("Parser configuration error during creation of Maven custom settings.xml");
            emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        catch (TransformerException ex) {
            messageError = new StringBuilder("Transformer error during creation of Maven custom settings.xml");
            emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        catch (SAXException ex) {
            messageError = new StringBuilder("XML parsing error during creation of Maven custom settings.xml");
            emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        mavenUtils.mvnCleanPackageWithProperties(this.installPath + "/" + this.artifactId, this.confDirectory, this.logsDirectory, this.bundlesDirectory, customMavenProxySettings);
        if (this.isProxyEnabled && this.mavenProxyAutoconf) {
            FileSystemUtils.delete(customMavenProxySettings);
        }
        switch (selectedContainer) {
            case TOMCAT: {
                Tomcat tomcat = new Tomcat(this.tomcatSsl, this.tomcatHost, this.tomcatPort, this.installPath, this.artifactId, this.tomcatUser, this.tomcatPassword, handler);
                boolean deployCoreResult = tomcat.deployCore();
                if (deployCoreResult) {
                    handler.logOutput("Core successfully deployed ", true);
                    InstallLog.getInstance().info("Core successfully deployed ");
                } else {
                    String messageError2 = "Deploy core on Tomcat failed";
                    handler.emitError("Deploy core on Tomcat failed", "Deploy core on Tomcat failed");
                    InstallLog.getInstance().error("Deploy core on Tomcat failed");
                }
                boolean deployConsoleResult = tomcat.deployConsole();
                if (deployConsoleResult) {
                    handler.logOutput("Console successfully deployed ", true);
                    InstallLog.getInstance().info("Console successfully deployed ");
                    break;
                }
                String messageError3 = "Deploy console on Tomcat failed";
                handler.emitError("Deploy console on Tomcat failed", "Deploy console on Tomcat failed");
                InstallLog.getInstance().error("Deploy console on Tomcat failed");
                break;
            }
            case JBOSS: {
                JBoss jBoss = new JBoss(this.jbossSsl, this.jbossHost, this.jbossPort, this.jbossAdminUsername, this.jbossAdminPassword, this.installPath, this.artifactId, handler);
                boolean deployCoreJboss = jBoss.deployCore();
                if (deployCoreJboss) {
                    handler.logOutput("Core successfully deployed ", true);
                    InstallLog.getInstance().info("Core successfully deployed ");
                } else {
                    String messageError4 = "Deploy core on JBoss failed";
                    handler.emitError("Deploy core on JBoss failed", "Deploy core on JBoss failed");
                    InstallLog.getInstance().error("Deploy core on JBoss failed");
                }
                boolean deployConsoleJBoss = jBoss.deployConsole();
                if (deployConsoleJBoss) {
                    handler.logOutput("Console successfully deployed ", true);
                    InstallLog.getInstance().info("Console successfully deployed ");
                    break;
                }
                String messageError5 = "Deploy console on JBoss failed";
                handler.emitError("Deploy console on JBoss failed", "Deploy console on JBoss failed");
                InstallLog.getInstance().error("Deploy console on JBoss failed");
                break;
            }
            case GLASSFISH: {
                String createJavaOptCommand = "sh " + this.glassfishDir + "/bin/asadmin create-jvm-options-Dcom.sun.enterprise.overrideablejavaxpackages=javax.ws.rs,javax.ws.rs.core,javax.ws.rs.ext";
                fileSystemUtils.exec(createJavaOptCommand, null);
                Glassfish glassfish = new Glassfish(this.installPath, this.artifactId);
                fileSystemUtils.exec("sh " + this.glassfishDir + "/bin/asadmin deploy " + glassfish.deployCore(), null);
                fileSystemUtils.exec("sh " + this.glassfishDir + "/bin/asadmin deploy " + glassfish.deployConsole(), null);
            }
        }
    }
}

