/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.processes;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.apache.syncope.installer.utilities.MavenUtils;
import org.xml.sax.SAXException;

public class ArchetypeProcess {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        String installPath = args[0];
        String mavenDir = args[1];
        String groupId = args[2];
        String artifactId = args[3];
        String secretKey = args[4];
        String anonymousKey = args[5];
        String confDirectory = args[6];
        String logsDirectory = args[7];
        String bundlesDirectory = args[8];
        String modelerDirectory = args[9];
        String syncopeVersion = args[10];
        String syncopeAdminPassword = args[11];
        boolean isProxyEnabled = Boolean.valueOf(args[12]);
        String proxyHost = args[13];
        String proxyPort = args[14];
        String proxyUser = args[15];
        String proxyPwd = args[16];
        boolean mavenProxyAutoconf = Boolean.valueOf(args[17]);
        FileSystemUtils fileSystemUtils = new FileSystemUtils(handler);
        fileSystemUtils.createDirectory(installPath);
        InstallLog.initialize(installPath, handler);
        MavenUtils mavenUtils = new MavenUtils(mavenDir, handler);
        File customMavenProxySettings = null;
        try {
            if (isProxyEnabled && mavenProxyAutoconf) {
                customMavenProxySettings = MavenUtils.createSettingsWithProxy(installPath, proxyHost, proxyPort, proxyUser, proxyPwd);
            }
        }
        catch (IOException ex) {
            StringBuilder messageError = new StringBuilder("I/O error during creation of Maven custom settings.xml");
            String emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        catch (ParserConfigurationException ex) {
            StringBuilder messageError = new StringBuilder("Parser configuration error during creation of Maven custom settings.xml");
            String emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        catch (TransformerException ex) {
            StringBuilder messageError = new StringBuilder("Transformer error during creation of Maven custom settings.xml");
            String emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        catch (SAXException ex) {
            StringBuilder messageError = new StringBuilder("XML parsing error during creation of Maven custom settings.xml");
            String emittedError = messageError.toString();
            handler.emitError(emittedError, emittedError);
            InstallLog.getInstance().error(messageError.append(ex.getMessage() == null ? "" : ex.getMessage()).toString());
        }
        handler.logOutput("########################## IMPORTANT ##########################", true);
        handler.logOutput("See " + InstallLog.getInstance().getFileAbsolutePath() + " for the maven logs", true);
        handler.logOutput("########################## IMPORTANT ##########################", true);
        mavenUtils.archetypeGenerate(syncopeVersion, groupId, artifactId, secretKey, anonymousKey, installPath, customMavenProxySettings);
        if (syncopeVersion.contains("SNAPSHOT")) {
            fileSystemUtils.writeToFile(new File(installPath + "/" + artifactId + "/pom.xml"), String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--\nLicensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n\"License\"); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n  http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing,\nsoftware distributed under the License is distributed on an\n\"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, either express or implied.  See the License for the\nspecific language governing permissions and limitations\nunder the License.\n\n--><project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n\n  <modelVersion>4.0.0</modelVersion>\n\n  <parent>\n    <groupId>org.apache.syncope</groupId>\n    <artifactId>syncope</artifactId>\n    <version xmlns=\"\">%s</version>\n  </parent>\n\n  <properties>\n    <syncope.version xmlns=\"\">%s</syncope.version>\n    <secretKey>ahsdgausygdausygduasygd</secretKey>\n    <anonymousKey>asdasdasdasd</anonymousKey>\n  </properties>\n\n  <name>Apache Syncope sample project</name>\n  <groupId>%s</groupId>\n  <artifactId>%s</artifactId>\n  <version>1.0-SNAPSHOT</version>\n  <packaging>pom</packaging>\n\n  <dependencyManagement>\n    <dependencies>\n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-common</artifactId>\n        <version>${syncope.version}</version>\n      </dependency> \n \n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-common</artifactId>\n        <version>${syncope.version}</version>\n        <classifier>javadoc</classifier>\n      </dependency>\n\n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-client</artifactId>\n        <version>${syncope.version}</version>\n      </dependency> \n\n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-build-tools</artifactId>\n        <version>${syncope.version}</version>\n        <type>war</type>\n        <scope>test</scope>\n      </dependency> \n            \n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-core</artifactId>\n        <version>${syncope.version}</version>\n        <type>war</type>\n      </dependency> \n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-core</artifactId>\n        <version>${syncope.version}</version>\n        <classifier>classes</classifier>\n        <scope>provided</scope>\n      </dependency> \n\n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-console</artifactId>\n        <version>${syncope.version}</version>\n        <type>war</type>\n      </dependency> \n      <dependency>\n        <groupId>org.apache.syncope</groupId>\n        <artifactId>syncope-console</artifactId>\n        <version>${syncope.version}</version>\n        <classifier>classes</classifier>\n        <scope>provided</scope>\n      </dependency> \n    </dependencies>\n  </dependencyManagement>\n    \n  <build>\n    \n    <pluginManagement>\n      <plugins>\n        <!-- Disable LICENSE / NOTICE inclusion: see SYNCOPE-84 -->\n        <plugin>\n          <groupId>org.apache.maven.plugins</groupId>\n          <artifactId>maven-war-plugin</artifactId>\n          <inherited>false</inherited>\n          <configuration>\n            <webResources>\n              <resource>\n                <directory>src/main/webapp</directory>\n                <includes>\n                  <include>**/*.jsp</include>\n                </includes>\n                <filtering>true</filtering>\n              </resource>\n            </webResources>\n          </configuration>\n        </plugin>\n      </plugins>\n    </pluginManagement>\n    \n    <!-- Disable legal check for generated projects: see SYNCOPE-84 -->\n    <plugins>\n      <plugin>\n        <groupId>org.codehaus.mojo</groupId>\n        <artifactId>ianal-maven-plugin</artifactId>\n        <inherited>true</inherited>\n        <executions>\n          <execution>            \n            <goals>\n              <goal>verify-legal-files</goal>\n            </goals>\n            <phase>none</phase>\n          </execution>\n        </executions>\n      </plugin>\n      <plugin>\n        <groupId>org.apache.rat</groupId>\n        <artifactId>apache-rat-plugin</artifactId>\n        <inherited>true</inherited>\n        <executions>\n          <execution>\n            <goals>\n              <goal>check</goal>\n            </goals>\n            <phase>none</phase>\n          </execution>\n        </executions>\n      </plugin>\n    </plugins>\n  </build>\n<repositories>\n  <repository>\n    <id>ASF</id>\n    <url>https://repository.apache.org/content/repositories/snapshots/</url>\n    <snapshots>\n      <enabled>true</enabled>\n    </snapshots>\n  </repository>\n</repositories>\n    \n  <modules>\n    <module>core</module>\n    <module>console</module>\n  </modules>\n\n</project>", syncopeVersion, syncopeVersion, groupId, artifactId));
        }
        fileSystemUtils.createDirectory(confDirectory);
        fileSystemUtils.createDirectory(logsDirectory);
        fileSystemUtils.createDirectory(bundlesDirectory);
        fileSystemUtils.createDirectory(modelerDirectory);
        fileSystemUtils.writeToFile(new File(modelerDirectory + "/pom.xml"), String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0\n                             http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n   \n  <groupId>org.apache.syncope</groupId>\n  <artifactId>activitiModelerSetup</artifactId>\n  <version>1.0-SNAPSHOT</version>\n  <packaging>jar</packaging>\n   \n  <properties>\n    <activiti.version>5.16.2</activiti.version>\n    <activiti-modeler.directory>%s</activiti-modeler.directory>\n    <tokenValueMap>%s/oryx.debug.js-tokenValueMap.properties</tokenValueMap>\n     \n    <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>\n  </properties>\n   \n  <dependencies>\n    <dependency>\n      <groupId>org.activiti</groupId>\n      <artifactId>activiti-webapp-explorer2</artifactId>           \n      <version>${activiti.version}</version>\n      <type>war</type>\n      <scope>test</scope>\n    </dependency>   \n  </dependencies>\n   \n  <build>   \n    <plugins>\n      <plugin>\n        <groupId>org.apache.maven.plugins</groupId>\n        <artifactId>maven-antrun-plugin</artifactId>\n        <version>1.7</version>\n        <executions>\n          <execution>\n            <id>setupActivitiModeler</id>\n            <phase>process-resources</phase>\n            <configuration>\n              <target>\n                <unzip src=\"${settings.localRepository}/org/activiti/activiti-webapp-explorer2/${activiti.version}/activiti-webapp-explorer2-${activiti.version}.war\"\n                       dest=\"${project.build.directory}/activiti-webapp-explorer2\" />\n                 \n                <mkdir dir=\"${activiti-modeler.directory}\" />\n                 \n                <mkdir dir=\"${activiti-modeler.directory}/editor\" />\n                <copy todir=\"${activiti-modeler.directory}/editor\">\n                  <fileset dir=\"${project.build.directory}/activiti-webapp-explorer2/editor\">\n                    <exclude name=\"oryx.js\" />\n                  </fileset>\n                </copy>\n                <copy file=\"${project.build.directory}/activiti-webapp-explorer2/WEB-INF/classes/plugins.xml\"\n                      todir=\"${activiti-modeler.directory}/editor\" />\n                <copy file=\"${project.build.directory}/activiti-webapp-explorer2/WEB-INF/classes/stencilset.json\"\n                      todir=\"${activiti-modeler.directory}/editor\" />\n                 \n                <mkdir dir=\"${activiti-modeler.directory}/explorer\" />\n                <copy todir=\"${activiti-modeler.directory}/explorer\">\n                  <fileset dir=\"${project.build.directory}/activiti-webapp-explorer2/explorer\" />\n                </copy>\n                 \n                <mkdir dir=\"${activiti-modeler.directory}/libs\" />\n                <copy todir=\"${activiti-modeler.directory}/libs\">\n                  <fileset dir=\"${project.build.directory}/activiti-webapp-explorer2/libs\" />\n                </copy>\n              </target>\n            </configuration>\n            <goals>\n              <goal>run</goal>\n            </goals>\n          </execution>\n        </executions>\n      </plugin>\n      <plugin>\n        <groupId>com.google.code.maven-replacer-plugin</groupId>\n        <artifactId>replacer</artifactId>\n        <version>1.5.3</version>\n        <executions>\n          <execution>\n            <phase>process-resources</phase>\n            <goals>\n              <goal>replace</goal>\n            </goals>                  \n          </execution>\n        </executions>\n        <configuration>\n          <file>${activiti-modeler.directory}/editor/oryx.debug.js</file>\n          <tokenValueMap>${tokenValueMap}</tokenValueMap>\n          <unescape>true</unescape>\n          <regex>false</regex>\n        </configuration>\n      </plugin>\n    </plugins>\n  </build>\n</project>", modelerDirectory, modelerDirectory));
        fileSystemUtils.writeToFile(new File(modelerDirectory + "/oryx.debug.js-tokenValueMap.properties"), "# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\nORYX.CONFIG.ROOT_PATH \\=\t\t\t\t\t\"../editor/\"; //TODO: Remove last slash!!=BASE_PATH =                                     window.location.toString().substr(0, window.location.toString().indexOf('/wicket'));\\nORYX.CONFIG.ROOT_PATH =\t\t\t\tBASE_PATH + \"/activiti-modeler/editor/\";\nORYX.CONFIG.EXPLORER_PATH \\=\t\t\t\t\"../explorer\";=ORYX.CONFIG.EXPLORER_PATH =\t\t\tBASE_PATH + \"/activiti-modeler/explorer\";\nORYX.CONFIG.LIBS_PATH \\=\t\t\t\t\t\"../libs\";=ORYX.CONFIG.LIBS_PATH =\t\t\t\tBASE_PATH + \"/activiti-modeler/libs\";\nORYX.CONFIG.SYNTAXCHECKER_URL \\==ORYX.CONFIG.PLUGINS_CONFIG =\t\t\tORYX.CONFIG.ROOT_PATH + \"plugins.xml\";\\nORYX.CONFIG.SYNTAXCHECKER_URL =\nthis._baseUrl \\= \"../editor/stencilsets/bpmn2.0/\";=this._baseUrl = ORYX.CONFIG.ROOT_PATH + \"stencilsets/bpmn2.0/\";\nthis._source \\= \"../stencilsets/bpmn2.0/bpmn2.0.json\";=this._source = ORYX.CONFIG.ROOT_PATH + \"stencilsets/bpmn2.0/bpmn2.0.json\";\n\"../service/editor/stencilset\"=ORYX.CONFIG.ROOT_PATH + \"stencilset.json\"\nORYX.Editor.createByUrl=modelUrl = BASE_PATH + \"/workflowDefGET\";\\nORYX.Editor.createByUrl\n../explorer/src/img/signavio/smoky/logo2.png=\"+ORYX.CONFIG.EXPLORER_PATH+\"/src/img/signavio/smoky/logo2.png\n<a href\\=\\\\\"\"+ORYX.CONFIG.WEB_URL+\"\\\\\" target\\=\\\\\"_self\\\\\" title\\=\\\\\"close modeler\\\\\">=<a href=\\\\\"#\\\\\" title=\\\\\"close modeler\\\\\" onclick=\\\\\"window.close();\\\\\">\n../editor/images/close_button.png=\"+ORYX.CONFIG.ROOT_PATH+\"images/close_button.png\nheight:16px;width:16px;margin-bottom:-4px;background: transparent url(../libs/ext-2.0.2/resources/images/default/tree/loading.gif) no-repeat center;=height:16px;width:16px;margin-bottom:-4px;background: transparent url(\"+ORYX.CONFIG.LIBS_PATH+\"/ext-2.0.2/resources/images/default/tree/loading.gif) no-repeat center;\nicon: '../editor/images/add.png',=icon: ORYX.CONFIG.ROOT_PATH + 'images/add.png',\nicon: '../editor/images/delete.png',=icon: ORYX.CONFIG.ROOT_PATH + 'images/delete.png',\nid\\=\"edit_model_title\"=id=\"edit_model_title\" readonly=\"readonly\"\nid\\=\"edit_model_summary\"=id=\"edit_model_summary\" readonly=\"readonly\"\n\"../service/model/\" + modelMeta.modelId + \"/json\"=BASE_PATH + \"/workflowDefGET\"\n// Send the request to the server.=saveUri = BASE_PATH + \"/workflowDefPUT\";\\n// Send the request to the server.\n'Accept':\"application/json\", 'Content-Type':'charset\\=UTF-8'='Accept':\"application/json\", 'Content-Type':'application/json'");
        mavenUtils.mvnCleanPackage(modelerDirectory, customMavenProxySettings);
        mavenUtils.mvnCleanPackageWithProperties(installPath + "/" + artifactId, confDirectory, logsDirectory, bundlesDirectory, customMavenProxySettings);
    }
}

