/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.containers;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.syncope.installer.containers.AbstractContainer;
import org.apache.syncope.installer.utilities.HttpUtils;

public class Tomcat
extends AbstractContainer {
    private static final boolean IS_WIN = System.getProperty("os.name").toLowerCase().contains("win");
    private static final String DEPLOY_SYNCOPE_CORE_QUERY = "/manager/text/deploy?path=/syncope&war=file:";
    private static final String DEPLOY_SYNCOPE_CONSOLE_QUERY = "/manager/text/deploy?path=/syncope-console&war=file:";
    private final String installPath;
    private final String artifactId;
    private final HttpUtils httpUtils;

    public Tomcat(boolean tomcatSsl, String tomcatHost, String tomcatPort, String installPath, String artifactId, String tomcatUser, String tomcatPassword, AbstractUIProcessHandler handler) {
        this.installPath = installPath;
        this.artifactId = artifactId;
        this.httpUtils = new HttpUtils(tomcatSsl, tomcatHost, tomcatPort, tomcatUser, tomcatPassword, handler);
    }

    public boolean deployCore() {
        int status = IS_WIN ? this.httpUtils.getWithBasicAuth(DEPLOY_SYNCOPE_CORE_QUERY + this.pathEncoded(String.format("%s\\%s\\core\\target\\syncope.war", this.installPath, this.artifactId))) : this.httpUtils.getWithBasicAuth(this.path("/manager/text/deploy?path=/syncope&war=file:%s/%s/core/target/syncope.war"));
        return status == 200;
    }

    public boolean deployConsole() {
        int status = IS_WIN ? this.httpUtils.getWithBasicAuth(DEPLOY_SYNCOPE_CONSOLE_QUERY + this.pathEncoded(String.format("%s\\%s\\console\\target\\syncope-console.war", this.installPath, this.artifactId))) : this.httpUtils.getWithBasicAuth(this.path("/manager/text/deploy?path=/syncope-console&war=file:%s/%s/console/target/syncope-console.war"));
        return status == 200;
    }

    private String pathEncoded(String what) {
        String path = "";
        try {
            path = URLEncoder.encode(what, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }

    private String path(String what) {
        return String.format(what, this.installPath, this.artifactId);
    }
}

