/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.types.Resource;
import com.izforge.izpack.util.file.types.ResourceFactory;
import com.izforge.izpack.util.file.types.selectors.SelectorUtils;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;

public class ResourceUtils {
    private static final Logger logger = Logger.getLogger(ResourceUtils.class.getName());

    public static Resource[] selectOutOfDateSources(Resource[] source, FileNameMapper mapper, ResourceFactory targets) throws Exception {
        return ResourceUtils.selectOutOfDateSources(source, mapper, targets, FileUtils.getFileUtils().getFileTimestampGranularity());
    }

    public static Resource[] selectOutOfDateSources(Resource[] resources, FileNameMapper mapper, ResourceFactory targets, long granularity) throws Exception {
        long now = new Date().getTime() + granularity;
        Vector<Resource> vresult = new Vector<Resource>();
        for (Resource resource : resources) {
            String[] targetnames;
            if (resource.getLastModified() > now) {
                logger.warning(resource.getName() + " modified in the future.");
            }
            if ((targetnames = mapper.mapFileName(resource.getName().replace('/', File.separatorChar))) != null) {
                boolean added = false;
                StringBuffer targetList = new StringBuffer();
                for (int ctarget = 0; !added && ctarget < targetnames.length; ++ctarget) {
                    Resource atarget = targets.getResource(targetnames[ctarget].replace(File.separatorChar, '/'));
                    if (!atarget.isExists()) {
                        logger.warning(resource.getName() + " added as " + atarget.getName() + " doesn't exist.");
                        vresult.addElement(resource);
                        added = true;
                        continue;
                    }
                    if (!atarget.isDirectory() && SelectorUtils.isOutOfDate(resource, atarget, (int)granularity)) {
                        logger.warning(resource.getName() + " added as " + atarget.getName() + " is outdated.");
                        vresult.addElement(resource);
                        added = true;
                        continue;
                    }
                    if (targetList.length() > 0) {
                        targetList.append(", ");
                    }
                    targetList.append(atarget.getName());
                }
                if (added) continue;
                logger.fine(resource.getName() + " omitted as " + targetList.toString() + (targetnames.length == 1 ? " is" : " are ") + " up to date.");
                continue;
            }
            logger.warning(resource.getName() + " skipped - don't know how to handle it");
        }
        Object[] result = new Resource[vresult.size()];
        vresult.copyInto(result);
        return result;
    }
}

