/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.validator;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.panels.userinput.validator.AbstractValidator;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordKeystoreValidator
extends AbstractValidator {
    private VariableSubstitutor variableSubstitutor;
    private static final Logger logger = Logger.getLogger(PasswordKeystoreValidator.class.getName());

    public PasswordKeystoreValidator(VariableSubstitutor variableSubstitutor) {
        this.variableSubstitutor = variableSubstitutor;
    }

    @Override
    public boolean validate(String[] values, Map<String, String> parameters) {
        boolean returnValue = false;
        Map<String, String> params = this.getParams(parameters);
        try {
            String keystoreFile;
            String skipValidation = params.get("skipValidation");
            logger.fine("skipValidation = " + skipValidation);
            if (skipValidation != null && skipValidation.equalsIgnoreCase("true")) {
                logger.fine("Not validating keystore");
                return true;
            }
            String keystorePassword = params.get("keystorePassword");
            if (keystorePassword == null) {
                keystorePassword = this.getPassword(values);
                logger.fine("keystorePassword parameter null, using validator password for keystore");
            } else if (keystorePassword.equalsIgnoreCase("")) {
                keystorePassword = this.getPassword(values);
                logger.fine("keystorePassword parameter empty, using validator password for keystore");
            }
            String aliasPassword = params.get("aliasPassword");
            if (aliasPassword == null) {
                aliasPassword = this.getPassword(values);
                logger.fine("aliasPassword parameter null, using validator password for key");
            } else if (aliasPassword.equalsIgnoreCase("")) {
                aliasPassword = this.getPassword(values);
                logger.fine("aliasPassword parameter empty, using validator password for key");
            }
            String keystoreType = params.get("keystoreType");
            if (keystoreType == null) {
                keystoreType = "JKS";
            }
            logger.fine("keystoreType parameter null, using default of JKS");
            if (keystoreType.equalsIgnoreCase("")) {
                keystoreType = "JKS";
                logger.fine("keystoreType parameter empty, using default of JKS");
            }
            if ((keystoreFile = params.get("keystoreFile")) != null) {
                logger.fine("Attempting to open keystore: " + keystoreFile);
                KeyStore keyStore = this.getKeyStore(keystoreFile, keystoreType, keystorePassword.toCharArray());
                if (keyStore != null) {
                    returnValue = true;
                    logger.fine("keystore password validated");
                    String alias = params.get("keystoreAlias");
                    if (alias != null) {
                        returnValue = keyStore.containsAlias(alias);
                        if (returnValue) {
                            logger.fine("keystore alias '" + alias + "' found, trying to retrieve");
                            try {
                                keyStore.getKey(alias, aliasPassword.toCharArray());
                                logger.fine("keystore alias '" + alias + "' validated");
                            }
                            catch (Exception e) {
                                logger.log(Level.FINE, "keystore alias validation failed: " + e, e);
                                returnValue = false;
                            }
                        } else {
                            logger.fine("keystore alias '" + alias + "' not found");
                        }
                    }
                }
            } else {
                logger.fine("keystoreFile param not provided");
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "validate() Failed: " + e, e);
        }
        return returnValue;
    }

    private Map<String, String> getParams(Map<String, String> parameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : parameters.keySet()) {
            String value = this.variableSubstitutor.substitute(parameters.get(key));
            result.put(key, value);
        }
        return result;
    }

    private String getPassword(String[] values) {
        return values.length > 0 ? values[0] : null;
    }

    private KeyStore getKeyStore(String fileName, String type, char[] password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(new FileInputStream(fileName), password);
        }
        catch (Exception e) {
            System.out.println("getKeyStore() Failed: " + e);
            keyStore = null;
        }
        return keyStore;
    }
}

