/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.validator;

import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(AbstractValidator.class.getName());

    @Override
    public boolean validate(ProcessingClient client) {
        boolean result = false;
        try {
            String[] values = this.getValues(client);
            Map<String, String> parameters = this.getParameters(client);
            result = this.validate(values, parameters);
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Validation failed: " + exception.getMessage(), exception);
        }
        return result;
    }

    public abstract boolean validate(String[] var1, Map<String, String> var2);

    protected Map<String, String> getParameters(ProcessingClient client) {
        return client.hasParams() ? client.getValidatorParams() : Collections.emptyMap();
    }

    protected String[] getValues(ProcessingClient client) {
        String[] values = new String[client.getNumFields()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = client.getFieldContents(i);
        }
        return values;
    }
}

