/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.processorclient;

import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import java.text.MessageFormat;
import java.util.Map;

public class ValuesProcessingClient
implements ProcessingClient {
    private final String[] values;
    private final MessageFormat format;
    private Map<String, String> parameters;

    public ValuesProcessingClient(String[] values) {
        this(null, values);
    }

    public ValuesProcessingClient(MessageFormat format, String[] values) {
        this(format, values, null);
    }

    public ValuesProcessingClient(MessageFormat format, String[] values, Map<String, String> parameters) {
        this.format = format;
        this.values = values;
        this.parameters = parameters;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public int getNumFields() {
        return this.values.length;
    }

    @Override
    public String getFieldContents(int index) {
        return this.values[index];
    }

    @Override
    public String getText() {
        if (this.format != null) {
            return this.format.format(this.values);
        }
        StringBuilder result = new StringBuilder();
        for (String value : this.values) {
            result.append(value);
        }
        return result.toString();
    }

    @Override
    public boolean hasParams() {
        return this.parameters != null;
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.parameters;
    }
}

