/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.text;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.text.TextField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GUITextField
extends GUIField
implements FocusListener,
DocumentListener {
    private final JTextField text;
    private transient boolean changed = false;

    public GUITextField(TextField field) {
        super(field);
        this.text = new JTextField(field.getInitialValue(), field.getSize());
        this.text.setName(field.getVariable());
        this.text.setCaretPosition(0);
        this.text.getDocument().addDocumentListener(this);
        this.text.addFocusListener(this);
        this.addField(this.text);
        this.addTooltip();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        boolean result = false;
        String text = this.text.getText();
        Field field = this.getField();
        ValidationStatus status = field.validate(text);
        if (skipValidation || status.isValid()) {
            field.setValue(text);
            result = true;
        } else {
            String message = status.getMessage();
            if (message == null) {
                message = "Text entered did not pass validation.";
            }
            this.warning(message, prompt);
        }
        return result;
    }

    @Override
    public boolean updateView() {
        boolean result = false;
        Field f = this.getField();
        String value = f.getInitialValue();
        if (value != null) {
            this.replaceValue(value);
            result = true;
        } else {
            String defaultValue = f.getDefaultValue();
            if (defaultValue != null) {
                this.replaceValue(defaultValue);
            }
        }
        return result;
    }

    private void replaceValue(String value) {
        boolean changed = false;
        String oldValue = this.text.getText();
        if (!(oldValue != null ? oldValue.equals(value) : value == null)) {
            this.text.getDocument().removeDocumentListener(this);
            this.text.setText(this.replaceVariables(value));
            this.text.getDocument().addDocumentListener(this);
            changed = true;
        }
        this.setChanged(changed);
    }

    public synchronized void setChanged(boolean changed) {
        this.changed = changed;
    }

    private synchronized boolean isChanged() {
        return this.changed;
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.text.selectAll();
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.isChanged()) {
            this.notifyUpdateListener();
            this.setChanged(false);
        }
        this.text.select(0, 0);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.text;
    }
}

