/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.search;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.GUIPrompt;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.userinput.field.search.ResultType;
import com.izforge.izpack.panels.userinput.field.search.SearchField;
import com.izforge.izpack.panels.userinput.field.search.SearchType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SearchInputField
implements ActionListener {
    private final String filename;
    private final String checkFilename;
    private final JButton autodetectButton;
    private final JButton browseButton;
    private final JComboBox pathComboBox;
    private final SearchType searchType;
    private final ResultType resultType;
    private final InstallerFrame parent;
    private final InstallData installData;

    public SearchInputField(SearchField field, final InstallerFrame parent, JComboBox combobox, JButton autobutton, JButton browsebutton, InstallData installData) {
        this.filename = field.getFilename();
        this.checkFilename = field.getCheckFilename();
        this.parent = parent;
        this.autodetectButton = autobutton;
        this.browseButton = browsebutton;
        this.pathComboBox = combobox;
        this.searchType = field.getType();
        this.resultType = field.getResultType();
        this.installData = installData;
        this.autodetectButton.addActionListener(this);
        this.browseButton.addActionListener(this);
        final JTextField editor = (JTextField)this.pathComboBox.getEditor().getEditorComponent();
        editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkNextButtonState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkNextButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkNextButtonState();
            }

            private void checkNextButtonState() {
                Document doc = editor.getDocument();
                try {
                    if (SearchInputField.this.pathMatches(doc.getText(0, doc.getLength()))) {
                        parent.unlockNextButton(false);
                    } else {
                        parent.lockNextButton();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.autodetect();
    }

    static String resolveEnvValue(String path, Map<String, String> env) {
        int end;
        int envStart;
        StringBuilder str = new StringBuilder();
        int start = 0;
        while ((envStart = path.indexOf(37, start)) >= 0 && (end = path.indexOf(37, envStart + 1)) >= 0) {
            String envKey = path.substring(envStart + 1, end);
            String envValue = env.get(envKey);
            if (envStart > start) {
                str.append(path.substring(start, envStart));
            }
            str.append(envValue);
            start = end + 1;
        }
        if (start > 0) {
            str.append(path.substring(start));
            return str.toString();
        }
        return path;
    }

    private boolean pathMatches(String path) {
        if (path != null) {
            path = SearchInputField.resolveEnvValue(path, System.getenv());
            File file = this.filename == null || this.searchType == SearchType.DIRECTORY ? new File(path) : new File(path, this.filename);
            if (file.exists()) {
                if (this.checkFilename == null) {
                    return true;
                }
                if (file.isDirectory()) {
                    if (!(file = new File(file, this.checkFilename)).exists()) {
                        System.out.println(file.getAbsolutePath() + " does not exist");
                        return false;
                    }
                } else if (!file.getAbsolutePath().endsWith(this.checkFilename.replaceAll("\\\\/", File.separator))) {
                    return false;
                }
                return file.isDirectory() == (this.searchType == SearchType.DIRECTORY);
            }
        }
        return false;
    }

    public boolean autodetect() {
        String path;
        String selected;
        ArrayList<String> items = new ArrayList<String>();
        for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
            if (!this.pathMatches((String)this.pathComboBox.getItemAt(x))) continue;
            this.pathComboBox.setSelectedIndex(x);
            break;
        }
        if ((selected = (String)this.pathComboBox.getSelectedItem()) == null) {
            this.parent.lockNextButton();
            return false;
        }
        boolean found = false;
        for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
            if (!this.pathComboBox.getItemAt(x).equals(selected)) continue;
            found = true;
        }
        if (!found) {
            this.pathComboBox.addItem(this.pathComboBox.getSelectedItem());
        }
        for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
            path = (String)this.pathComboBox.getItemAt(i);
            path = this.installData.getVariables().replace(path);
            if (path.endsWith("*")) {
                File[] subdirs;
                File dir = new File(path = path.substring(0, path.length() - 1));
                if (!dir.isDirectory() || (subdirs = dir.listFiles()) == null) continue;
                for (File subdir : subdirs) {
                    String search = subdir.getAbsolutePath();
                    if (!this.pathMatches(search)) continue;
                    items.add(search);
                }
                continue;
            }
            if (!this.pathMatches(path)) continue;
            items.add(path);
        }
        items = new ArrayList(new LinkedHashSet(items));
        this.pathComboBox.removeAllItems();
        for (String item : items) {
            item = this.installData.getVariables().replace(item);
            this.pathComboBox.addItem(item);
        }
        for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
            path = (String)this.pathComboBox.getItemAt(i);
            if (!this.pathMatches(path)) continue;
            this.pathComboBox.setSelectedIndex(i);
            this.parent.unlockNextButton();
            return true;
        }
        if (this.pathMatches((String)this.pathComboBox.getSelectedItem())) {
            this.parent.unlockNextButton();
            return true;
        }
        this.parent.lockNextButton();
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.autodetectButton) {
            if (!this.autodetect()) {
                this.warning("UserInputPanel.search.autodetect.failed.caption", "UserInputPanel.search.autodetect.failed.message");
            }
        } else if (event.getSource() == this.browseButton) {
            int result;
            File dir;
            String startingPath;
            JFileChooser chooser = new JFileChooser();
            if (this.resultType != ResultType.FILE) {
                chooser.setFileSelectionMode(1);
            }
            if ((startingPath = (String)this.pathComboBox.getSelectedItem()) == null && this.pathComboBox.getItemCount() != 0) {
                startingPath = (String)this.pathComboBox.getItemAt(0);
            }
            if (startingPath != null && (dir = new File(startingPath)).exists()) {
                chooser.setCurrentDirectory(dir);
            }
            if ((result = chooser.showOpenDialog(this.parent)) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.pathComboBox.setSelectedItem(selectedFile.getAbsolutePath());
                if (this.resultType != ResultType.FILE && !this.pathMatches(selectedFile.getAbsolutePath())) {
                    this.warning("UserInputPanel.search.wrongselection.caption", "UserInputPanel.search.wrongselection.message");
                }
            }
        }
    }

    public String getResult() {
        String item = (String)this.pathComboBox.getSelectedItem();
        if (item != null) {
            item = item.trim();
        }
        String path = item;
        File file = new File(item);
        if (!file.isDirectory()) {
            path = file.getParent();
        }
        if (this.resultType == ResultType.DIRECTORY) {
            return path;
        }
        if (this.resultType == ResultType.FILE) {
            if (this.filename != null) {
                return path + File.separatorChar + this.filename;
            }
            return item;
        }
        if (this.resultType == ResultType.PARENTDIR) {
            File dir = new File(path);
            return dir.getParent();
        }
        return null;
    }

    private void warning(String title, String message) {
        Messages messages = this.parent.getMessages();
        title = messages.get(title, new Object[0]);
        message = messages.get(message, new Object[0]);
        new GUIPrompt().message(Prompt.Type.WARNING, title, message);
    }
}

