/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.rule;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.rule.RuleField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import com.izforge.izpack.panels.userinput.gui.rule.RuleInputField;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class GUIRuleField
extends GUIField {
    private final RuleInputField component;

    public GUIRuleField(RuleField field) {
        super(field);
        this.component = new RuleInputField(field);
        int id = 1;
        for (JTextField input : this.component.getInputFields()) {
            input.setName(field.getVariable() + "." + id);
            ++id;
        }
        this.addField(this.component);
        this.addTooltip();
    }

    public String getValue() {
        return this.component.getText();
    }

    public String[] getValues() {
        return this.component.getValues();
    }

    public void setValues(String ... values) {
        this.component.setValues(values);
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        boolean result = false;
        Field field = this.getField();
        ValidationStatus status = field.validate(this.component.getValues());
        if (skipValidation || status.isValid()) {
            field.setValue(this.component.getText());
            result = true;
        } else if (status.getMessage() != null) {
            prompt.warn(status.getMessage());
        }
        return result;
    }

    @Override
    public boolean updateView() {
        boolean changed = false;
        Field f = this.getField();
        String value = f.getInitialValue();
        if (value != null) {
            changed = this.replaceValue(value);
        } else {
            String defaultValue = f.getDefaultValue();
            if (defaultValue != null) {
                changed = this.replaceValue(defaultValue);
            }
        }
        return changed;
    }

    private boolean replaceValue(String value) {
        ValidationStatus status;
        RuleField f = (RuleField)this.getField();
        boolean changed = false;
        if (value != null && (status = f.validateFormatted(value)).isValid()) {
            String[] values = status.getValues();
            int id = 0;
            for (JTextField input : this.component.getInputFields()) {
                String oldValue = input.getText();
                String newValue = values[id];
                if (!(oldValue != null ? oldValue.equals(newValue) : newValue == null)) {
                    input.setText(newValue);
                    changed = true;
                }
                ++id;
            }
        }
        return changed;
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        List<JTextField> inputFields = this.component.getInputFields();
        if (!inputFields.isEmpty()) {
            return this.component.getInputFields().get(0);
        }
        return null;
    }
}

