/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.file;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.file.MultipleFileField;
import com.izforge.izpack.panels.userinput.gui.file.UserInputFileFilter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultipleFileInputField
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 4673684743657328492L;
    private static final transient Logger logger = Logger.getLogger(MultipleFileInputField.class.getName());
    private final MultipleFileField field;
    boolean isDirectory;
    InstallerFrame parentFrame;
    DefaultListModel model;
    JList fileList;
    JButton browseBtn;
    JButton deleteBtn;
    String set;
    int size;
    GUIInstallData data;
    String fileExtension;
    String fileExtensionDescription;
    boolean allowEmpty;
    boolean createMultipleVariables;
    int visibleRows = 10;
    int preferredX = 200;
    int preferredY = 200;
    String labeltext;

    public MultipleFileInputField(MultipleFileField field, InstallerFrame parent, GUIInstallData data, boolean directory) {
        this.field = field;
        this.parentFrame = parent;
        this.data = data;
        this.set = field.getDefaultValue();
        this.size = field.getSize();
        if (this.size < 1) {
            this.size = 1;
        }
        this.fileExtension = field.getFileExtension();
        this.fileExtensionDescription = field.getFileExtensionDescription();
        this.isDirectory = directory;
        this.createMultipleVariables = field.getCreateMultipleVariables();
        this.visibleRows = field.getVisibleRows() > 0 ? field.getVisibleRows() : 10;
        this.preferredX = field.getPreferredWidth() > 0 ? field.getPreferredWidth() : 200;
        this.preferredY = field.getPreferredHeight() > 0 ? field.getPreferredHeight() : 200;
        this.labeltext = field.getLabel();
        this.allowEmpty = field.getAllowEmptyValue();
        this.initialize();
    }

    public void clearFiles() {
        this.model.clear();
    }

    public void addFile(String file) {
        this.model.addElement(file);
    }

    public void initialize() {
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        JLabel label = new JLabel(this.labeltext);
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        main.add(labelPanel);
        this.model = new DefaultListModel();
        this.fileList = new JList(this.model);
        this.fileList.setSelectionMode(0);
        this.fileList.setVisibleRowCount(this.visibleRows);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        Messages messages = this.data.getMessages();
        this.browseBtn = ButtonFactory.createButton(messages.get("UserInputPanel.search.browse", new Object[0]), this.data.buttonsHColor);
        this.browseBtn.setName(GuiId.BUTTON_BROWSE.id);
        this.browseBtn.addActionListener(this);
        this.deleteBtn = ButtonFactory.createButton(messages.get("UserInputPanel.search.delete", new Object[0]), this.data.buttonsHColor);
        this.deleteBtn.addActionListener(this);
        JScrollPane scroller = new JScrollPane(this.fileList);
        scroller.setPreferredSize(new Dimension(this.preferredX, this.preferredY));
        panel.add(scroller);
        buttonPanel.add(this.browseBtn);
        buttonPanel.add(this.deleteBtn);
        buttonPanel.add(Box.createVerticalGlue());
        panel.add(buttonPanel);
        main.add(panel);
        main.add(Box.createVerticalGlue());
        this.add(main);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.browseBtn) {
            logger.fine("Show directory chooser");
            String initialPath = ".";
            if (this.fileList.getSelectedValue() != null) {
                initialPath = (String)this.fileList.getSelectedValue();
            }
            JFileChooser filechooser = new JFileChooser(initialPath);
            if (this.isDirectory) {
                filechooser.setFileSelectionMode(1);
            } else {
                filechooser.setFileSelectionMode(0);
                if (this.fileExtension != null && this.fileExtensionDescription != null) {
                    UserInputFileFilter fileFilter = new UserInputFileFilter();
                    fileFilter.setFileExt(this.fileExtension);
                    fileFilter.setFileExtDesc(this.fileExtensionDescription);
                    filechooser.setFileFilter(fileFilter);
                }
            }
            if (filechooser.showOpenDialog(this.parentFrame) == 0) {
                String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
                this.model.addElement(selectedFile);
                logger.fine("Setting current file chooser directory to: " + selectedFile);
            }
        }
        if (arg0.getSource() == this.deleteBtn) {
            logger.fine("Delete selected file from list");
            if (this.fileList.getSelectedValue() != null) {
                this.model.removeElement(this.fileList.getSelectedValue());
            }
        }
    }

    public List<String> getSelectedFiles() {
        ArrayList<String> result = null;
        if (this.model.size() > 0) {
            result = new ArrayList<String>();
            Enumeration elements = this.model.elements();
            while (elements.hasMoreElements()) {
                String element = (String)elements.nextElement();
                result.add(element);
            }
        }
        return result;
    }

    private void showMessage(String messageType) {
        JOptionPane.showMessageDialog(this.parentFrame, this.parentFrame.getMessages().get("UserInputPanel." + messageType + ".message", new Object[0]), this.parentFrame.getMessages().get("UserInputPanel." + messageType + ".caption", new Object[0]), 2);
    }

    private boolean validateFile(String input) {
        boolean result = false;
        if (this.allowEmpty && (input == null || input.length() == 0)) {
            result = true;
        } else if (input != null) {
            File file = new File(input);
            if (this.isDirectory && !file.isDirectory()) {
                result = false;
                this.showMessage("dir.notdirectory");
            } else if (!this.isDirectory && !file.isFile()) {
                result = false;
                this.showMessage("file.notfile");
            } else {
                ValidationStatus status = this.field.validate(input);
                if (!status.isValid()) {
                    JOptionPane.showMessageDialog(this.parentFrame, status.getMessage(), this.parentFrame.getMessages().get("UserInputPanel.error.caption", new Object[0]), 2);
                } else {
                    result = true;
                }
            }
        } else if (this.isDirectory) {
            this.showMessage("dir.nodirectory");
        } else {
            this.showMessage("file.nofile");
        }
        return result;
    }

    public boolean validateField() {
        boolean result = false;
        int fileCount = this.model.getSize();
        if (fileCount == 0 && this.allowEmpty) {
            return true;
        }
        for (int i = 0; i < fileCount && (result = this.validateFile((String)this.model.getElementAt(i))); ++i) {
        }
        return result;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public boolean isCreateMultipleVariables() {
        return this.createMultipleVariables;
    }
}

