/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.file;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.userinput.field.file.MultipleFileField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import com.izforge.izpack.panels.userinput.gui.file.MultipleFileInputField;
import javax.swing.JComponent;

public class GUIMultipleFileField
extends GUIField {
    private final MultipleFileInputField fileInput;

    public GUIMultipleFileField(MultipleFileField field, GUIInstallData installData, InstallerFrame parent) {
        super(field);
        this.fileInput = new MultipleFileInputField(field, parent, installData, false);
        this.addComponent(this.fileInput, new TwoColumnConstraints(26));
        this.addTooltip();
    }

    @Override
    public MultipleFileField getField() {
        return (MultipleFileField)super.getField();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        boolean result = this.fileInput.validateField();
        if (skipValidation || result) {
            this.getField().setValues(this.fileInput.getSelectedFiles());
        }
        return result;
    }

    @Override
    public boolean updateView() {
        boolean result = false;
        String value = this.getField().getInitialValue();
        if (value != null) {
            this.splitValue(value);
            result = true;
        } else {
            MultipleFileField field = this.getField();
            String defaultValue = field.getDefaultValue();
            if (defaultValue != null) {
                this.splitValue(defaultValue);
            }
        }
        return result;
    }

    private void splitValue(String value) {
        this.fileInput.clearFiles();
        if (this.fileInput.isCreateMultipleVariables()) {
            this.fileInput.addFile(value);
            String basevariable = this.getVariable();
            int index = 1;
            while (value != null) {
                StringBuilder builder = new StringBuilder(basevariable);
                builder.append("_");
                builder.append(index++);
                value = this.getInstallData().getVariable(builder.toString());
                if (value == null) continue;
                this.fileInput.addFile(value);
            }
        } else {
            String[] files;
            for (String file : files = value.split(";")) {
                this.fileInput.addFile(file);
            }
        }
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.fileInput;
    }
}

