/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.custom;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.panels.userinput.FieldCommand;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.custom.Column;
import com.izforge.izpack.panels.userinput.field.custom.CustomField;
import com.izforge.izpack.panels.userinput.gui.Component;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class CustomInputRows
extends JPanel {
    private final UserInputPanelSpec userInputPanelSpec;
    private final IXMLElement spec;
    private final FieldCommand createField;
    private int numberOfRows = 0;
    private final int numberOfColumns;
    private Map<Integer, List<GUIField>> guiFields;
    private final CustomField customInfoField;
    private final int maxRow;
    private final int minRow;
    private final List<String> labels;
    private GUIInstallData installData;

    public CustomInputRows(CustomField customField, FieldCommand createField, UserInputPanelSpec userInputPanelSpec, IXMLElement spec, GUIInstallData installData) {
        this.spec = spec;
        this.userInputPanelSpec = userInputPanelSpec;
        this.createField = createField;
        this.customInfoField = customField;
        this.numberOfColumns = this.getNumberOfColumns(this.customInfoField);
        this.maxRow = customField.getMaxRow();
        this.minRow = customField.getMinRow();
        this.labels = this.getLabels(this.customInfoField);
        this.guiFields = new HashMap<Integer, List<GUIField>>();
        this.installData = installData;
        super.setLayout(new GridLayout(0, this.numberOfColumns));
        this.addInitialRows();
    }

    private void addInitialRows() {
        for (int count = this.minRow; count > 0; --count) {
            this.addRow();
        }
    }

    public void addRow() {
        List<Object> fields;
        ++this.numberOfRows;
        if (this.guiFields.size() >= this.numberOfRows) {
            fields = this.guiFields.get(this.numberOfRows);
        } else {
            fields = new ArrayList();
            for (Field field : this.createCustomField(this.userInputPanelSpec, this.spec).getFields()) {
                GUIField guiField = this.createField.createGuiField(field);
                guiField.setVariable(guiField.getVariable() + "." + this.numberOfRows);
                fields.add(guiField);
            }
            this.guiFields.put(this.numberOfRows, fields);
        }
        for (GUIField gUIField : fields) {
            gUIField.setDisplayed(true);
            for (Component component : gUIField.getComponents()) {
                JComponent jComponent = component.getComponent();
                Object jConstraints = component.getConstraints();
                if (jComponent instanceof JLabel || jComponent instanceof JTextPane) continue;
                this.add((java.awt.Component)jComponent, jConstraints);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void removeRow() {
        for (int colNumber = this.numberOfColumns; colNumber > 0; --colNumber) {
            this.remove(this.getComponentCount() - colNumber);
        }
        this.guiFields.remove(this.numberOfRows);
        --this.numberOfRows;
        this.revalidate();
        this.repaint();
    }

    public boolean atMax() {
        return this.numberOfRows < this.maxRow;
    }

    public boolean atMin() {
        return this.numberOfRows > this.minRow;
    }

    public boolean hideRowControls() {
        return this.maxRow == this.minRow;
    }

    public boolean updateField(Prompt prompt, boolean skipValidation) {
        this.installData.setVariable(this.customInfoField.getVariable(), this.numberOfRows + "");
        for (int i = 1; i <= this.numberOfRows; ++i) {
            for (GUIField guiField : this.guiFields.get(i)) {
                if (!guiField.isDisplayed() || guiField.updateField(prompt, skipValidation)) continue;
                return false;
            }
        }
        List<Column> columns = this.customInfoField.getColumns();
        String[] columnVariables = this.getVariablesByColumn();
        for (int i = 0; i < columnVariables.length; ++i) {
            ValidationStatus status;
            if (skipValidation || (status = columns.get(i).validate(columnVariables[i])).isValid()) continue;
            prompt.warn(status.getMessage());
            return false;
        }
        return true;
    }

    public List<String> getLabels(CustomField customInfoField) {
        ArrayList<String> labels = new ArrayList<String>();
        for (Field field : customInfoField.getFields()) {
            GUIField guiField = this.createField.createGuiField(field);
            labels.add(guiField.getSummaryKey());
        }
        return labels;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getVariables() {
        ArrayList<String> countedVariables = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfRows; ++i) {
            for (GUIField guiField : this.guiFields.get(i)) {
                if (!guiField.isDisplayed()) continue;
                countedVariables.add(guiField.getVariable());
            }
        }
        return countedVariables;
    }

    private String[] getVariablesByColumn() {
        String[] columnVariables = new String[this.numberOfColumns];
        for (int col = 0; col < this.numberOfColumns; ++col) {
            columnVariables[col] = "";
            for (int row = 1; row <= this.numberOfRows; ++row) {
                GUIField guiField = this.guiFields.get(row).get(col);
                if (!guiField.isDisplayed()) continue;
                int n = col;
                columnVariables[n] = columnVariables[n] + this.installData.getVariable(guiField.getVariable()) + ",";
            }
        }
        for (int i = 0; i < columnVariables.length; ++i) {
            String v = columnVariables[i];
            columnVariables[i] = v.substring(0, v.length() - 1);
        }
        return columnVariables;
    }

    public int getNumberOfColumns(CustomField customInfoField) {
        return customInfoField.getFields().size();
    }

    private CustomField createCustomField(UserInputPanelSpec userInputPanelSpec, IXMLElement spec) {
        List<Field> fields = userInputPanelSpec.createFields(spec);
        for (Field field : fields) {
            if (!(field instanceof CustomField) || !field.getVariable().equals(this.customInfoField.getVariable())) continue;
            return (CustomField)field;
        }
        return null;
    }

    public JPanel getHeader() {
        JPanel header = new JPanel(new GridLayout(1, this.numberOfColumns));
        for (Field field : this.customInfoField.getFields()) {
            String heading = field.getDescription();
            if (heading == null) {
                heading = field.getLabel();
            }
            JLabel label = new JLabel(heading);
            header.add(label);
        }
        return header;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (java.awt.Component component : this.getComponents()) {
            component.setEnabled(enabled);
        }
    }
}

