/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.check;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.panels.userinput.field.check.CheckField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class GUICheckField
extends GUIField {
    private final JCheckBox checkbox;

    public GUICheckField(CheckField field) {
        super(field);
        this.checkbox = new JCheckBox(field.getLabel());
        this.checkbox.setName(field.getVariable());
        this.checkbox.setSelected(field.getInitialSelection());
        this.checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUICheckField.this.notifyUpdateListener();
            }
        });
        this.addDescription();
        TwoColumnConstraints constraints = new TwoColumnConstraints(29);
        constraints.stretch = true;
        constraints.indent = true;
        this.addComponent(this.checkbox, constraints);
        this.addTooltip();
    }

    @Override
    public CheckField getField() {
        return (CheckField)super.getField();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        CheckField field = this.getField();
        if (this.checkbox.isSelected()) {
            field.setValue(field.getTrueValue());
        } else {
            field.setValue(field.getFalseValue());
        }
        return true;
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.checkbox;
    }
}

