/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.panels.userinput.field.AbstractFieldView;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.gui.Component;
import com.izforge.izpack.panels.userinput.gui.UpdateListener;
import com.izforge.izpack.util.HyperlinkHandler;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public abstract class GUIField
extends AbstractFieldView {
    private List<Component> components = new ArrayList<Component>();
    private UpdateListener listener;

    public GUIField(Field field) {
        super(field);
    }

    public boolean updateField(Prompt prompt) {
        return this.updateField(prompt, false);
    }

    public boolean updateField(Prompt prompt, boolean skipValidation) {
        return true;
    }

    public boolean updateView() {
        return false;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public abstract JComponent getFirstFocusableComponent();

    public void setUpdateListener(UpdateListener listener) {
        this.listener = listener;
    }

    protected void addField(JComponent component) {
        this.addDescription();
        this.addLabel();
        this.addComponent(component);
    }

    protected void addLabel() {
        this.addLabel(this.getField().getLabel());
    }

    protected void addLabel(String label) {
        this.addComponent(new JLabel(label), new TwoColumnConstraints(15));
    }

    protected void addComponent(JComponent component, Object constraints) {
        this.components.add(new Component(component, constraints));
    }

    public final boolean translateStaticText() {
        boolean updated = false;
        for (Component c : this.components) {
            JLabel label;
            String newText;
            String oldText;
            JComponent jc = c.getComponent();
            if (jc instanceof JTextPane) {
                JTextPane pane = (JTextPane)jc;
                oldText = pane.getText();
                if (oldText == null) continue;
                newText = this.replaceVariables(oldText);
                updated |= oldText.equals(newText);
                pane.setText(newText);
                continue;
            }
            if (!(jc instanceof JLabel) || (oldText = (label = (JLabel)jc).getText()) == null) continue;
            newText = this.replaceVariables(oldText);
            updated |= oldText.equals(newText);
            label.setText(newText);
        }
        return updated;
    }

    protected void addTooltip() {
        String tooltipId = this.getField().getTooltip();
        if (tooltipId != null) {
            String tooltip = this.getInstallData().getMessages().get(tooltipId, new Object[0]);
            for (Component component : this.components) {
                component.getComponent().setToolTipText(tooltip);
            }
        }
    }

    protected void addDescription() {
        this.addText(this.getField().getDescription());
    }

    protected void addText(String text) {
        if (text != null) {
            TwoColumnConstraints constraints = new TwoColumnConstraints(29);
            constraints.stretch = true;
            JTextPane label = new JTextPane();
            label.setEditable(false);
            label.setFocusable(false);
            if (text.startsWith("<html>") && text.endsWith("</html>")) {
                label.setContentType("text/html");
                label.addHyperlinkListener(new HyperlinkHandler());
            }
            label.setText(text);
            label.setBackground(UIManager.getColor("label.background"));
            label.setMargin(new Insets(3, 0, 3, 0));
            label.getPreferredSize();
            this.addComponent(label, constraints);
        }
    }

    protected void notifyUpdateListener() {
        if (this.listener != null) {
            this.listener.updated();
        }
    }

    protected InstallData getInstallData() {
        return this.getField().getInstallData();
    }

    protected String replaceVariables(String value) {
        return this.getInstallData().getVariables().replace(value);
    }

    protected void warning(String message, Prompt prompt) {
        Messages messages = this.getInstallData().getMessages();
        prompt.warn(messages.get("UserInputPanel.error.caption", new Object[0]), message);
    }

    private void addComponent(JComponent component) {
        this.addComponent(component, new TwoColumnConstraints(26));
    }
}

