/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.file;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.userinput.field.file.AbstractFileField;
import com.izforge.izpack.panels.userinput.field.file.MultipleFileFieldConfig;
import java.util.ArrayList;
import java.util.List;

public class MultipleFileField
extends AbstractFileField {
    private final int visibleRows;
    private final int width;
    private final int height;
    private final boolean multipleVariables;
    private final List<String> variables = new ArrayList<String>();

    public MultipleFileField(MultipleFileFieldConfig config, InstallData installData) {
        super(config, installData);
        this.visibleRows = config.getVisibleRows();
        this.width = config.getPreferredWidth();
        this.height = config.getPreferredHeight();
        this.multipleVariables = config.getCreateMultipleVariables();
        this.variables.add(this.getVariable());
    }

    public void setValues(List<String> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        if (this.multipleVariables) {
            InstallData installData = this.getInstallData();
            this.variables.clear();
            String variable = this.getVariable();
            this.variables.add(variable);
            int index = 0;
            for (String value : values) {
                String newVariable = variable;
                if (index > 0) {
                    newVariable = newVariable + "_" + index;
                    this.variables.add(newVariable);
                }
                ++index;
                installData.setVariable(newVariable, value);
            }
        } else {
            StringBuilder buffer = new StringBuilder();
            for (String value : values) {
                buffer.append(value);
                buffer.append(";");
            }
            this.setValue(buffer.toString());
        }
    }

    @Override
    public List<String> getVariables() {
        return this.variables;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getPreferredWidth() {
        return this.width;
    }

    public int getPreferredHeight() {
        return this.height;
    }

    public boolean getCreateMultipleVariables() {
        return this.multipleVariables;
    }
}

