/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.button;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.panels.userinput.action.ButtonAction;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.SimpleFieldReader;
import com.izforge.izpack.panels.userinput.field.button.ButtonFieldConfig;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ButtonFieldReader
extends SimpleFieldReader
implements ButtonFieldConfig {
    private final Messages messages;
    private final InstallData installData;

    public ButtonFieldReader(IXMLElement field, Config config, InstallData installData) {
        super(field, config);
        this.installData = installData;
        this.messages = installData.getMessages();
    }

    @Override
    protected IXMLElement getSpec(IXMLElement field, Config config) {
        return config.getElement(field, "spec");
    }

    @Override
    public String getLabel() {
        return this.getText(this.getField());
    }

    @Override
    public String getButtonName() {
        return this.getText(this.getSpec());
    }

    @Override
    public String getSuccessMsg() {
        String successMsg = this.getSpec().getAttribute("successMsg");
        if (successMsg == null) {
            successMsg = "";
        }
        return this.messages.get(successMsg, new Object[0]);
    }

    @Override
    public List<ButtonAction> getButtonActions() {
        ArrayList<ButtonAction> buttonActions = new ArrayList<ButtonAction>();
        for (IXMLElement runSpec : this.getSpec().getChildrenNamed("run")) {
            HashMap<String, String> buttonMessages = new HashMap<String, String>();
            String actionClass = runSpec.getAttribute("class");
            try {
                Class<?> buttonActionClass = Class.forName(actionClass);
                Constructor<?> buttonActionConstructor = buttonActionClass.getConstructor(InstallData.class);
                ButtonAction buttonAction = (ButtonAction)buttonActionConstructor.newInstance(this.installData);
                for (IXMLElement message : runSpec.getChildrenNamed("msg")) {
                    String id = message.getAttribute("id");
                    String name = message.getAttribute("name");
                    String value = this.messages.get(id, new Object[0]);
                    buttonMessages.put(name, value);
                }
                buttonAction.setMessages(buttonMessages);
                buttonActions.add(buttonAction);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return buttonActions;
    }
}

