/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.panels.userinput.field.Choice;
import com.izforge.izpack.panels.userinput.field.ChoiceFieldConfig;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.FieldReader;
import com.izforge.izpack.panels.userinput.processor.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SimpleChoiceReader
extends FieldReader
implements ChoiceFieldConfig {
    private InstallData installData;
    private String defaultValue;

    public SimpleChoiceReader(IXMLElement field, Config config, InstallData installData) {
        super(field, config);
        this.installData = installData;
        for (IXMLElement choice : this.getSpec().getChildrenNamed("choice")) {
            if (!this.getConfig().getBoolean(choice, "set", false)) continue;
            this.defaultValue = config.getAttribute(choice, "value");
            break;
        }
    }

    @Override
    public List<Choice> getChoices() {
        ArrayList<Choice> result = new ArrayList<Choice>();
        Config config = this.getConfig();
        for (IXMLElement choice : this.getSpec().getChildrenNamed("choice")) {
            String processorClass = choice.getAttribute("processor");
            String conditionId = config.getString(choice, "conditionid", null);
            if (processorClass != null && !"".equals(processorClass)) {
                String values;
                try {
                    Processor processor = config.getFactory().create(processorClass, Processor.class, new Object[0]);
                    values = processor.process(null);
                }
                catch (Throwable exception) {
                    throw new IzPackException("Failed to get choices from processor=" + processorClass + " in " + config.getContext(choice), exception);
                }
                StringTokenizer tokenizer = new StringTokenizer(values, ":");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    result.add(new Choice(token, token, conditionId));
                }
                continue;
            }
            String value = config.getAttribute(choice, "value");
            result.add(new Choice(value, this.getText(choice), conditionId));
        }
        return result;
    }

    protected boolean isSelected(String value, IXMLElement choice, String variableValue) {
        boolean result = false;
        if (variableValue != null) {
            if (variableValue.equals(value)) {
                result = true;
            }
        } else {
            result = this.defaultValue != null && this.defaultValue.equals(variableValue);
        }
        return result;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getSelectedIndex(String variable) {
        int selected = 0;
        int result = 0;
        Config config = this.getConfig();
        RulesEngine rules = this.installData.getRules();
        String variableValue = this.installData.getVariable(variable);
        for (IXMLElement choice : this.getSpec().getChildrenNamed("choice")) {
            String value = config.getAttribute(choice, "value");
            String conditionId = config.getString(choice, "conditionid", null);
            String set = config.getAttribute(choice, "set", true);
            if (variableValue == null) {
                if (set != null && set.equalsIgnoreCase("true")) {
                    result = selected;
                }
            } else if (this.isDisplayed(rules, conditionId) && this.isSelected(value, choice, variableValue)) {
                return selected;
            }
            ++selected;
        }
        return result;
    }

    private boolean isDisplayed(RulesEngine rules, String conditionId) {
        return rules == null || conditionId == null || rules.isConditionTrue(conditionId);
    }
}

