/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.panels.userinput.field.Config;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FieldValidatorReader {
    private final IXMLElement validator;
    private final Config config;

    public FieldValidatorReader(IXMLElement validator, Config config) {
        this.validator = validator;
        this.config = config;
    }

    public String getClassName() {
        return this.config.getAttribute(this.validator, "class");
    }

    public String getMessage() {
        return this.config.getText(this.validator);
    }

    public Map<String, String> getParameters() {
        Map<String, String> result = Collections.emptyMap();
        List<IXMLElement> params = this.validator.getChildrenNamed("param");
        if (!params.isEmpty()) {
            result = new LinkedHashMap<String, String>();
            for (IXMLElement parameter : params) {
                String name = this.config.getAttribute(parameter, "name");
                String value = parameter.getAttribute("value");
                result.put(name, value);
            }
        }
        return result;
    }
}

