/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.panels.userinput.processorclient.ValuesProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldValidator {
    private final String className;
    private final String message;
    private Map<String, String> parameters;
    private final ObjectFactory factory;
    private Validator validator;
    private static final Logger logger = Logger.getLogger(FieldValidator.class.getName());

    public FieldValidator(Class type, String message, ObjectFactory factory) {
        this(type.getName(), null, message, factory);
    }

    public FieldValidator(String className, Map<String, String> parameters, String message, ObjectFactory factory) {
        this.className = className;
        this.parameters = parameters;
        this.message = message;
        this.factory = factory;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean validate(String[] values) {
        return this.validate(new ValuesProcessingClient(values));
    }

    public boolean validate(ValuesProcessingClient values) {
        boolean result = false;
        try {
            if (this.validator == null) {
                this.validator = this.factory.create(this.className, Validator.class, new Object[0]);
            }
            values.setParameters(this.parameters);
            result = this.validator.validate(values);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Validation " + (result ? "OK" : "FAILED") + " using " + this.validator.getClass().getSimpleName());
            }
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Validation using " + this.className + " failed: " + exception.getMessage(), exception);
        }
        return result;
    }
}

