/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.ElementReader;
import com.izforge.izpack.panels.userinput.field.FieldConfig;
import com.izforge.izpack.panels.userinput.field.FieldProcessor;
import com.izforge.izpack.panels.userinput.field.FieldValidator;
import com.izforge.izpack.panels.userinput.field.FieldValidatorReader;
import java.util.ArrayList;
import java.util.List;

public class FieldReader
extends ElementReader
implements FieldConfig {
    private final IXMLElement field;
    private final IXMLElement spec;
    protected static final String VARIABLE = "variable";
    protected static final String SUMMARY_KEY = "summaryKey";
    protected static final String DISPLAY_HIDDEN = "displayHidden";
    protected static final String DISPLAY_HIDDEN_CONDITION = "displayHiddenCondition";
    protected static final String READONLY = "readonly";
    protected static final String READONLY_CONDITION = "readonlyCondition";
    protected static final String TEXT_SIZE = "size";
    protected static final String SPEC = "spec";
    protected static final String VALIDATOR = "validator";
    protected static final String TOOLTIP = "tooltip";
    protected static final String OMIT_FROM_AUTO = "omitFromAuto";

    public FieldReader(IXMLElement field, Config config) {
        super(config);
        this.field = field;
        this.spec = this.getSpec(field, config);
    }

    public IXMLElement getField() {
        return this.field;
    }

    public IXMLElement getSpec() {
        return this.spec;
    }

    @Override
    public boolean getOmitFromAuto() {
        return this.getConfig().getBoolean(this.getSpec(), OMIT_FROM_AUTO, false);
    }

    @Override
    public String getVariable() {
        return this.getConfig().getAttribute(this.getField(), VARIABLE);
    }

    @Override
    public String getSummaryKey() {
        return this.getConfig().getAttribute(this.getField(), SUMMARY_KEY, true);
    }

    @Override
    public Boolean isDisplayHidden() {
        return this.getConfig().getBooleanOrNull(this.getField(), DISPLAY_HIDDEN);
    }

    @Override
    public String getDisplayHiddenCondition() {
        return this.getConfig().getAttribute(this.getField(), DISPLAY_HIDDEN_CONDITION, true);
    }

    @Override
    public Boolean isReadonly() {
        return this.getConfig().getBooleanOrNull(this.getField(), READONLY);
    }

    @Override
    public String getReadonlyCondition() {
        return this.getConfig().getAttribute(this.getField(), READONLY_CONDITION, true);
    }

    @Override
    public List<String> getPacks() {
        return this.getPacks(this.field);
    }

    @Override
    public List<OsModel> getOsModels() {
        return this.getOsModels(this.field);
    }

    @Override
    public String getDefaultValue() {
        return this.spec != null ? this.getConfig().getRawString(this.spec, "default", null) : null;
    }

    @Override
    public String getInitialValue() {
        return this.spec != null ? this.getConfig().getRawString(this.spec, "set", null) : null;
    }

    @Override
    public int getSize() {
        int result = -1;
        if (this.spec != null) {
            result = this.getConfig().getInt(this.spec, TEXT_SIZE, result);
        }
        return result;
    }

    @Override
    public List<FieldValidator> getValidators(IXMLElement field) {
        ArrayList<FieldValidator> result = new ArrayList<FieldValidator>();
        Config config = this.getConfig();
        for (IXMLElement element : field.getChildrenNamed(VALIDATOR)) {
            FieldValidatorReader reader = new FieldValidatorReader(element, config);
            result.add(new FieldValidator(reader.getClassName(), reader.getParameters(), reader.getMessage(), config.getFactory()));
        }
        return result;
    }

    @Override
    public List<FieldValidator> getValidators() {
        return this.getValidators(this.field);
    }

    @Override
    public FieldProcessor getProcessor() {
        IXMLElement element = this.spec != null ? this.spec.getFirstChildNamed("processor") : null;
        return element != null ? new FieldProcessor(element, this.getConfig()) : null;
    }

    @Override
    public String getDescription() {
        return this.getText(this.field.getFirstChildNamed("description"));
    }

    @Override
    public String getTooltip() {
        return this.getConfig().getAttribute(this.field, TOOLTIP, true);
    }

    @Override
    public String getLabel() {
        return this.getText(this.getSpec());
    }

    @Override
    public String getCondition() {
        return this.getConfig().getString(this.getField(), "conditionid", null);
    }

    protected IXMLElement getSpec(IXMLElement field, Config config) {
        return config.getElement(field, SPEC);
    }

    protected String getText(IXMLElement element) {
        return this.getConfig().getText(element);
    }
}

