/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.processor.Processor;
import com.izforge.izpack.panels.userinput.processorclient.ValuesProcessingClient;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldProcessor {
    private final Config config;
    private final String className;
    private Processor processor;
    private static final Logger logger = Logger.getLogger(FieldProcessor.class.getName());

    public FieldProcessor(IXMLElement processor, Config config) {
        this.className = config.getAttribute(processor, "class");
        this.config = config;
    }

    public String process(String[] values) {
        String result;
        try {
            if (this.processor == null) {
                this.processor = this.config.getFactory().create(this.className, Processor.class, new Object[0]);
            }
            result = this.processor.process(new ValuesProcessingClient(values));
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Processing using " + this.className + " failed: " + exception.getMessage(), exception);
            if (exception instanceof IzPackException) {
                throw (IzPackException)exception;
            }
            throw new IzPackException("Processing using " + this.className + " failed: " + exception.getMessage(), exception);
        }
        return result;
    }
}

