/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.rules.process.ExistsCondition;
import com.izforge.izpack.panels.userinput.field.FieldConfig;
import com.izforge.izpack.panels.userinput.field.FieldProcessor;
import com.izforge.izpack.panels.userinput.field.FieldValidator;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.processorclient.ValuesProcessingClient;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Field {
    private String variable;
    private final String summaryKey;
    private final String initialValue;
    private final String defaultValue;
    private final int size;
    private final List<String> packs;
    private final List<OsModel> models;
    private final List<FieldValidator> validators;
    private final FieldProcessor processor;
    private final String label;
    private final String description;
    private final String tooltip;
    private final String condition;
    private Boolean displayHidden;
    private String displayHiddenCondition;
    private Boolean readonly;
    private String readonlyCondition;
    private final InstallData installData;
    private boolean omitFromAuto;
    private static final Logger logger = Logger.getLogger(Field.class.getName());

    public Field(FieldConfig config, InstallData installData) {
        this.variable = config.getVariable();
        this.summaryKey = config.getSummaryKey();
        this.initialValue = config.getInitialValue();
        this.defaultValue = config.getDefaultValue();
        this.size = config.getSize();
        this.packs = config.getPacks();
        this.models = config.getOsModels();
        this.validators = config.getValidators();
        this.processor = config.getProcessor();
        this.label = config.getLabel();
        this.description = config.getDescription();
        this.displayHidden = config.isDisplayHidden();
        this.displayHiddenCondition = config.getDisplayHiddenCondition();
        this.readonly = config.isReadonly();
        this.readonlyCondition = config.getReadonlyCondition();
        this.tooltip = config.getTooltip();
        this.omitFromAuto = config.getOmitFromAuto();
        this.condition = config.getCondition();
        this.installData = installData;
        if (this.variable != null) {
            this.addExistsCondition();
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public boolean getOmitFromAuto() {
        return this.omitFromAuto;
    }

    public List<String> getVariables() {
        return this.variable != null ? Arrays.asList(this.variable) : Collections.emptyList();
    }

    public String getSummaryKey() {
        return this.summaryKey;
    }

    public Boolean isDisplayHidden() {
        return this.displayHidden;
    }

    public String getDisplayHiddenCondition() {
        return this.displayHiddenCondition;
    }

    public Boolean isReadonly() {
        return this.readonly;
    }

    public boolean isEffectiveReadonly(boolean defaultFlag, RulesEngine rules) {
        boolean result = false;
        result = this.readonly != null ? this.readonly : (this.readonlyCondition != null && rules.isConditionTrue(this.readonlyCondition) ? rules.isConditionTrue(this.readonlyCondition) : defaultFlag);
        return result;
    }

    public boolean isEffectiveDisplayHidden(boolean defaultFlag, RulesEngine rules) {
        boolean result = false;
        result = this.displayHidden != null ? this.displayHidden : (this.displayHiddenCondition != null && rules.isConditionTrue(this.displayHiddenCondition) ? rules.isConditionTrue(this.displayHiddenCondition) : defaultFlag);
        return result;
    }

    public String getReadonlyCondition() {
        return this.readonlyCondition;
    }

    public List<String> getPacks() {
        return this.packs;
    }

    public List<OsModel> getOsModels() {
        return this.models;
    }

    public String getDefaultValue() {
        if (this.defaultValue != null) {
            return this.replaceVariables(this.defaultValue);
        }
        return null;
    }

    private String getForcedValue() {
        if (this.initialValue != null) {
            return this.replaceVariables(this.initialValue);
        }
        return null;
    }

    public String getInitialValue() {
        String result = null;
        if (!this.installData.getVariables().isBlockedVariableName(this.variable)) {
            result = this.getForcedValue();
        }
        if (result == null && (result = this.getValue()) == null) {
            result = this.getDefaultValue();
        }
        return result;
    }

    public String getValue() {
        return this.installData.getVariable(this.variable);
    }

    public void setValue(String value) {
        value = this.process(value);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Field setting variable=" + this.variable + " to value=" + value);
        }
        this.installData.setVariable(this.variable, value);
    }

    public int getSize() {
        return this.size;
    }

    public ValidationStatus validate(String ... values) {
        return this.validate(new ValuesProcessingClient(values));
    }

    public ValidationStatus validate(MessageFormat format, String ... values) {
        return this.validate(new ValuesProcessingClient(format, values));
    }

    public ValidationStatus validate(ValuesProcessingClient values) {
        try {
            for (FieldValidator validator : this.validators) {
                if (validator.validate(values)) continue;
                return ValidationStatus.failed(validator.getMessage());
            }
        }
        catch (Throwable exception) {
            return ValidationStatus.failed(exception.getMessage());
        }
        return ValidationStatus.success(values.getValues());
    }

    public String process(String ... values) {
        String result = null;
        if (this.processor != null) {
            result = this.processor.process(values);
        } else if (values.length > 0) {
            result = values[0];
        }
        return result;
    }

    public FieldProcessor getProcessor() {
        return this.processor;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean isConditionTrue() {
        RulesEngine rules = this.getRules();
        return this.condition == null || rules.isConditionTrue(this.condition, this.installData);
    }

    public InstallData getInstallData() {
        return this.installData;
    }

    protected RulesEngine getRules() {
        return this.installData.getRules();
    }

    protected String replaceVariables(String value) {
        return this.installData.getVariables().replace(value);
    }

    private void addExistsCondition() {
        RulesEngine rules = this.getRules();
        String conditionId = "izpack.input." + this.variable;
        if (rules != null) {
            if (rules.getCondition(conditionId) == null) {
                ExistsCondition existsCondition = new ExistsCondition();
                existsCondition.setContentType(ExistsCondition.ContentType.VARIABLE);
                existsCondition.setContent(this.variable);
                existsCondition.setId(conditionId);
                existsCondition.setInstallData(this.installData);
                rules.addCondition(existsCondition);
            } else {
                logger.fine("Condition '" + conditionId + "' for variable '" + this.variable + "' already exists");
            }
        } else {
            logger.fine("Cannot add  condition '" + conditionId + "' for variable '" + this.variable + "'. Rules not supplied");
        }
    }

    public void setVariable(String newVariableName) {
        this.variable = newVariableName;
    }
}

