/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.panels.userinput.field.Alignment;
import com.izforge.izpack.util.file.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Config {
    private final String path;
    private final InstallData installData;
    private final ObjectFactory factory;
    private final IXMLElement root;
    private final Messages messages;
    private static final String TEXT = "txt";
    private static final String KEY = "id";
    private static final Logger logger = Logger.getLogger(Config.class.getName());

    public Config(String path, Resources resources, InstallData installData, ObjectFactory factory, Messages messages) {
        XMLParser parser = new XMLParser();
        URL url = resources.getURL(path);
        this.path = url.getPath();
        this.installData = installData;
        this.factory = factory;
        this.messages = messages;
        InputStream input = null;
        try {
            input = url.openStream();
            this.root = parser.parse(input);
        }
        catch (IOException exception) {
            throw new IzPackException("Failed to open: " + path);
        }
        finally {
            FileUtils.close(input);
        }
    }

    public String getPath() {
        return this.path;
    }

    public IXMLElement getRoot() {
        return this.root;
    }

    public IXMLElement getElement(IXMLElement parent, String name) {
        IXMLElement child = parent.getFirstChildNamed(name);
        if (child == null) {
            String message = "<" + parent.getName() + "> requires child <" + name + ">";
            throw new IzPackException(this.getContext(parent) + ": " + message);
        }
        return child;
    }

    public String getAttribute(IXMLElement element, String name) {
        return this.getAttribute(element, name, false);
    }

    public String getAttribute(IXMLElement element, String name, boolean optional) {
        String value = element.getAttribute(name);
        if (!optional && value == null) {
            String message = "<" + element.getName() + "> requires attribute '" + name + "'";
            throw new IzPackException(this.getContext(element) + ": " + message);
        }
        return value;
    }

    public String getString(IXMLElement element, String name, String defaultValue) {
        String value = element.getAttribute(name);
        if (value != null && !value.equals("")) {
            value = this.installData.getVariables().replace(value);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getRawString(IXMLElement element, String name, String defaultValue) {
        String value = element.getAttribute(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getLocalString(String value) {
        return this.messages.get(value, new Object[0]);
    }

    public int getInt(IXMLElement element, String name, int defaultValue) {
        int result = defaultValue;
        String value = this.getString(element, name, null);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                logger.warning("Invalid value for attribute '" + name + "':" + value + " in " + this.getContext(element));
            }
        }
        return result;
    }

    public boolean getBoolean(IXMLElement element, String name, boolean defaultValue) {
        boolean result = defaultValue;
        String value = this.getString(element, name, null);
        if (value != null && !value.equals("")) {
            result = value.equals("yes") || Boolean.valueOf(value) != false;
        }
        return result;
    }

    public Boolean getBooleanOrNull(IXMLElement element, String name) {
        Boolean result = null;
        String value = this.getString(element, name, null);
        if (value != null && !value.isEmpty()) {
            result = value.equals("yes") || Boolean.valueOf(value) != false;
        }
        return result;
    }

    public String getText(IXMLElement element) {
        String result = null;
        if (element != null) {
            String key = element.getAttribute(KEY);
            if (key != null && key.equals(result = this.messages.get(key, new Object[0]))) {
                result = null;
            }
            if (result == null) {
                result = element.getAttribute(TEXT);
            }
            result = this.installData.getVariables().replace(result);
        }
        return result;
    }

    public Alignment getAlignment(IXMLElement element, String name, Alignment defaultValue) {
        Alignment result = defaultValue;
        String value = this.getString(element, name, defaultValue != null ? defaultValue.toString() : null);
        if (value != null) {
            try {
                result = Alignment.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                logger.log(Level.INFO, "Invalid value for 'align': " + value + " in " + this.getContext(element));
            }
        }
        return result;
    }

    public String getContext(IXMLElement element) {
        return this.path + ":" + element.getLineNr();
    }

    public ObjectFactory getFactory() {
        return this.factory;
    }
}

