/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console.file;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.search.SearchField;
import com.izforge.izpack.util.Console;
import java.util.List;

public class ConsoleSearchField
extends ConsoleField {
    public ConsoleSearchField(SearchField field, Console console, Prompt prompt) {
        super(field, console, prompt);
    }

    @Override
    public boolean display() {
        SearchField field = (SearchField)this.getField();
        this.printDescription();
        if (this.isReadonly()) {
            this.println(field.getValue());
            return true;
        }
        List<String> choices = field.getChoices();
        this.listChoices(choices, field.getSelectedIndex());
        int selected = this.getConsole().prompt("input selection: ", 0, choices.size() - 1, field.getSelectedIndex(), -1);
        if (selected == -1) {
            return false;
        }
        field.setValue(choices.get(selected));
        return true;
    }

    protected void listChoices(List<String> choices, int selected) {
        for (int i = 0; i < choices.size(); ++i) {
            String choice = choices.get(i);
            this.println(i + "  [" + (i == selected ? "x" : " ") + "] " + choice);
        }
    }
}

