/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.util.Console;

public abstract class ConsoleInputField
extends ConsoleField {
    public ConsoleInputField(Field field, Console console, Prompt prompt) {
        super(field, console, prompt);
    }

    @Override
    public boolean display() {
        String value;
        boolean result = false;
        this.printDescription();
        Field field = this.getField();
        if (this.isReadonly()) {
            this.println(field.getLabel() + " [" + field.getValue() + "] ");
            return true;
        }
        String initialValue = field.getInitialValue();
        if (initialValue == null) {
            initialValue = "";
        }
        if ((value = this.getConsole().prompt(field.getLabel() + " [" + initialValue + "] ", initialValue, null)) != null) {
            ValidationStatus status = this.validate(value);
            if (!status.isValid()) {
                this.error(status.getMessage());
            } else {
                field.setValue(value);
                result = true;
            }
        }
        return result;
    }

    protected ValidationStatus validate(String value) {
        return this.getField().validate(value);
    }
}

