/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.Choice;
import com.izforge.izpack.panels.userinput.field.ChoiceField;
import com.izforge.izpack.util.Console;
import java.util.List;

public abstract class ConsoleChoiceField<T extends Choice>
extends ConsoleField {
    public ConsoleChoiceField(ChoiceField field, Console console, Prompt prompt) {
        super(field, console, prompt);
    }

    @Override
    public ChoiceField getField() {
        return (ChoiceField)super.getField();
    }

    @Override
    public boolean display() {
        ChoiceField field = this.getField();
        this.printDescription();
        if (this.isReadonly()) {
            this.println(field.getValue());
            return true;
        }
        List<Choice> choices = field.getChoices();
        this.listChoices(choices, field.getSelectedIndex());
        int selected = this.getConsole().prompt(this.getMessage("ConsoleInstaller.inputSelection"), 0, choices.size() - 1, field.getSelectedIndex(), -1);
        if (selected == -1) {
            return false;
        }
        field.setValue(choices.get(selected).getKey());
        return true;
    }

    protected void listChoices(List<Choice> choices, int selected) {
        for (int i = 0; i < choices.size(); ++i) {
            Choice choice = choices.get(i);
            this.println(i + "  [" + (i == selected ? "x" : " ") + "] " + choice.getValue());
        }
    }
}

