/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.userinput.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.console.ConsoleFieldFactory;
import com.izforge.izpack.panels.userinput.field.ElementReader;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldHelper;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class UserInputConsolePanel
extends AbstractConsolePanel {
    private final Resources resources;
    private final ObjectFactory factory;
    private final RulesEngine rules;
    private final PlatformModelMatcher matcher;
    private final Console console;
    private final Prompt prompt;
    private List<ConsoleField> fields = new ArrayList<ConsoleField>();
    private final InstallData installData;

    public UserInputConsolePanel(Resources resources, ObjectFactory factory, RulesEngine rules, PlatformModelMatcher matcher, Console console, Prompt prompt, PanelView<ConsolePanel> panel, InstallData installData) {
        super(panel);
        this.installData = installData;
        this.resources = resources;
        this.factory = factory;
        this.rules = rules;
        this.matcher = matcher;
        this.console = console;
        this.prompt = prompt;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        this.collectInputs(installData);
        for (ConsoleField field : this.fields) {
            String value;
            String name = field.getVariable();
            if (name == null || (value = properties.getProperty(name)) == null) continue;
            installData.setVariable(name, value);
        }
        return true;
    }

    @Override
    public boolean generateProperties(InstallData installData, PrintWriter printWriter) {
        this.collectInputs(installData);
        for (ConsoleField field : this.fields) {
            String name = field.getVariable();
            if (name == null) continue;
            printWriter.println(name + "=");
        }
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        boolean result;
        if (!this.collectInputs(installData)) {
            result = true;
        } else {
            boolean rerun = false;
            Panel panel = this.getPanel();
            HashSet<String> variables = new HashSet<String>();
            for (ConsoleField field : this.fields) {
                Field fieldDefinition = field.getField();
                boolean readonly = false;
                boolean addToPanel = false;
                boolean required = FieldHelper.isRequired(fieldDefinition, installData, this.matcher);
                if (required && fieldDefinition.isConditionTrue()) {
                    readonly = fieldDefinition.isEffectiveReadonly(panel.isReadonly() || panel.getReadonlyCondition() != null && this.rules.isConditionTrue(panel.getReadonlyCondition()), this.rules);
                    addToPanel = true;
                } else if (required && fieldDefinition.isEffectiveDisplayHidden(panel.isDisplayHidden() || panel.getDisplayHiddenCondition() != null && this.rules.isConditionTrue(panel.getDisplayHiddenCondition()), this.rules)) {
                    readonly = true;
                    addToPanel = true;
                } else {
                    readonly = true;
                    addToPanel = false;
                }
                if (!addToPanel) continue;
                field.setReadonly(readonly);
                if (!field.display()) {
                    rerun = true;
                    break;
                }
                String var = fieldDefinition.getVariable();
                if (var == null) continue;
                variables.add(var);
            }
            panel.setAffectedVariableNames(variables);
            result = rerun ? this.promptRerunPanel(installData, console) : this.promptEndPanel(installData, console);
        }
        return result;
    }

    private boolean collectInputs(InstallData installData) {
        UserInputPanelSpec model = new UserInputPanelSpec(this.resources, installData, this.factory, this.matcher);
        Panel panel = this.getPanel();
        IXMLElement spec = model.getPanelSpec(panel);
        ElementReader reader = new ElementReader(model.getConfig());
        List<String> forPacks = reader.getPacks(spec);
        List<String> forUnselectedPacks = reader.getUnselectedPacks(spec);
        List<OsModel> forOs = reader.getOsModels(spec);
        if (!(FieldHelper.isRequiredForPacks(forPacks, installData.getSelectedPacks()) && FieldHelper.isRequiredForUnselectedPacks(forUnselectedPacks, installData.getSelectedPacks()) && this.matcher.matchesCurrentPlatform(forOs))) {
            return false;
        }
        this.fields.clear();
        ConsoleFieldFactory factory = new ConsoleFieldFactory(this.console, this.prompt);
        for (Field fieldDefinition : model.createFields(spec)) {
            ConsoleField consoleField = factory.create(fieldDefinition, model, spec);
            this.fields.add(consoleField);
        }
        return true;
    }

    @Override
    public void createInstallationRecord(IXMLElement rootElement) {
        new UserInputPanelAutomationHelper(this.fields).createInstallationRecord(this.installData, rootElement);
    }
}

