/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.panels.process.ButtonConfig;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class ProcessPanelWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "ProcessPanel.Spec.xml";
    private AbstractUIProcessHandler handler;
    private ArrayList<ProcessingJob> jobs = new ArrayList();
    private ArrayList<ProcessingJob> catchJobs = new ArrayList();
    private ArrayList<ProcessingJob> finalJobs = new ArrayList();
    private boolean result = true;
    private PrintWriter logfile = null;
    private String logfiledir = null;
    private final InstallData idata;
    private final Map<Boolean, List<ButtonConfig>> buttonConfigs = new HashMap<Boolean, List<ButtonConfig>>();
    private final RulesEngine rules;
    private final Resources resources;
    private final PlatformModelMatcher matcher;
    private static final Logger logger = Logger.getLogger(ProcessPanelWorker.class.getName());

    public ProcessPanelWorker(InstallData installData, RulesEngine rules, Resources resources, PlatformModelMatcher matcher) {
        this.idata = installData;
        this.rules = rules;
        this.resources = resources;
        this.matcher = matcher;
    }

    public void setHandler(AbstractUIProcessHandler handler) {
        this.handler = handler;
    }

    private boolean readSpec() throws IOException {
        String conditionid;
        IXMLElement spec;
        InputStream input;
        try {
            input = this.resources.getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to read ProcessPanel.Spec.xml", e);
            return false;
        }
        XMLParser parser = new XMLParser();
        try {
            spec = parser.parse(input);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to parse ProcessPanel.Spec.xml", e);
            return false;
        }
        if (!spec.hasChildren()) {
            return false;
        }
        IXMLElement logFileDirElement = spec.getFirstChildNamed("logfiledir");
        if (logFileDirElement != null) {
            this.logfiledir = logFileDirElement.getContent();
        }
        for (IXMLElement job_el : spec.getChildrenNamed("job")) {
            String ef_name;
            List<OsModel> constraints;
            String string = job_el.hasAttribute("condition") ? job_el.getAttribute("condition") : (conditionid = job_el.hasAttribute("conditionid") ? job_el.getAttribute("conditionid") : null);
            if (conditionid != null && conditionid.length() > 0) {
                logger.fine("Checking condition for job: " + conditionid);
                Condition cond = this.rules.getCondition(conditionid);
                if (cond != null && !cond.isTrue()) {
                    logger.fine("condition " + conditionid + " is not fulfilled.");
                    continue;
                }
            }
            logger.fine("Condition " + conditionid + " is fulfilled or does not exist");
            List<IXMLElement> forPacks = job_el.getChildrenNamed("executeForPack");
            if (!this.jobRequiredFor(forPacks) || !this.matcher.matchesCurrentPlatform(constraints = OsConstraintHelper.getOsList(job_el))) continue;
            ArrayList<Processable> ef_list = new ArrayList<Processable>();
            String job_name = job_el.getAttribute("name", "");
            for (IXMLElement executeFileElement : job_el.getChildrenNamed("executefile")) {
                ef_name = executeFileElement.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executefile>");
                    return false;
                }
                String ef_working_dir = executeFileElement.getAttribute("workingDir");
                ArrayList<String> args = new ArrayList<String>();
                for (IXMLElement arg_el : executeFileElement.getChildrenNamed("arg")) {
                    String arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ArrayList<String> envvars = new ArrayList<String>();
                for (IXMLElement env_el : executeFileElement.getChildrenNamed("env")) {
                    String env_val = env_el.getContent();
                    envvars.add(env_val);
                }
                ef_list.add(new ExecutableFile(ef_name, args, envvars, ef_working_dir));
            }
            for (IXMLElement executeClassElement : job_el.getChildrenNamed("executeclass")) {
                ef_name = executeClassElement.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executeclass>");
                    return false;
                }
                ArrayList<String> args = new ArrayList<String>();
                for (IXMLElement arg_el : executeClassElement.getChildrenNamed("arg")) {
                    String arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ef_list.add(new ExecutableClass(ef_name, args));
            }
            Boolean isCatch = job_el.hasAttribute("catch") && Boolean.parseBoolean(job_el.getAttribute("catch"));
            Boolean isFinal = job_el.hasAttribute("final") && Boolean.parseBoolean(job_el.getAttribute("final"));
            if (ef_list.isEmpty()) {
                logger.fine("Nothing to do for job '" + job_name + "'");
                continue;
            }
            if (isCatch.booleanValue()) {
                this.catchJobs.add(new ProcessingJob(job_name, ef_list));
                continue;
            }
            if (isFinal.booleanValue()) {
                this.finalJobs.add(new ProcessingJob(job_name, ef_list));
                continue;
            }
            this.jobs.add(new ProcessingJob(job_name, ef_list));
        }
        this.buttonConfigs.put(Boolean.FALSE, new ArrayList());
        this.buttonConfigs.put(Boolean.TRUE, new ArrayList());
        for (IXMLElement onFailElement : spec.getChildrenNamed("onFail")) {
            conditionid = onFailElement.hasAttribute("condition") ? onFailElement.getAttribute("condition") : (onFailElement.hasAttribute("conditionid") ? onFailElement.getAttribute("conditionid") : null);
            boolean unlockPrev = onFailElement.hasAttribute("previous") ? Boolean.parseBoolean(onFailElement.getAttribute("previous")) : false;
            boolean unlockNext = onFailElement.hasAttribute("next") ? Boolean.parseBoolean(onFailElement.getAttribute("next")) : false;
            this.buttonConfigs.get(Boolean.FALSE).add(new ButtonConfig(conditionid, unlockPrev, unlockNext));
        }
        for (IXMLElement onSuccessElement : spec.getChildrenNamed("onSuccess")) {
            conditionid = onSuccessElement.hasAttribute("condition") ? onSuccessElement.getAttribute("condition") : (onSuccessElement.hasAttribute("conditionid") ? onSuccessElement.getAttribute("conditionid") : null);
            boolean unlockPrev = onSuccessElement.hasAttribute("previous") ? Boolean.parseBoolean(onSuccessElement.getAttribute("previous")) : false;
            this.buttonConfigs.get(Boolean.TRUE).add(new ButtonConfig(conditionid, unlockPrev, true));
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.jobs.clear();
            if (!this.readSpec()) {
                System.err.println("Error parsing XML specification for processing.");
                return;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            return;
        }
        if (this.logfiledir != null) {
            this.logfiledir = IoHelper.translatePath(this.logfiledir, this.idata.getVariables());
            String appVersion = this.idata.getVariable("APP_VER");
            appVersion = appVersion != null ? "V" + appVersion : "undef";
            String identifier = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            identifier = appVersion.replace(' ', '_') + "_" + identifier;
            try {
                File tempLogFile = File.createTempFile("Install_" + identifier + "_", ".log", new File(this.logfiledir));
                this.logfile = new PrintWriter(new FileOutputStream(tempLogFile), true);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob processingJob : this.jobs) {
            this.result = this.runJob(processingJob);
            if (this.result) continue;
            for (ProcessingJob catchJob : this.catchJobs) {
                this.runJob(catchJob);
            }
        }
        for (ProcessingJob finalJob : this.finalJobs) {
            this.runJob(finalJob);
        }
        boolean unlockNext = true;
        boolean unlockPrev = false;
        for (ButtonConfig buttonConfig : this.buttonConfigs.get(this.result)) {
            String conditionid = buttonConfig.getConditionid();
            if (conditionid != null && conditionid.length() > 0) {
                logger.fine("Condition for job: " + conditionid);
                Condition cond = this.rules.getCondition(conditionid);
                if (cond != null && !cond.isTrue()) {
                    logger.fine("Condition " + conditionid + " is not fulfilled");
                    continue;
                }
            }
            unlockNext = buttonConfig.isUnlockNext();
            unlockPrev = buttonConfig.isUnlockPrev();
            break;
        }
        this.handler.finishProcessing(unlockPrev, unlockNext);
        if (this.logfile != null) {
            this.logfile.close();
        }
    }

    private boolean runJob(ProcessingJob job) {
        this.handler.startProcess(job.name);
        Boolean val = job.run(this.handler, this.idata.getVariables());
        this.handler.finishProcess();
        return val;
    }

    public void startThread() {
        Thread processingThread = new Thread((Runnable)this, "processing thread");
        processingThread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean jobRequiredFor(List<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.getSelectedPacks().size(); ++i) {
            String selected = this.idata.getSelectedPacks().get(i).getName();
            for (IXMLElement pack : packs) {
                String required = pack.getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private static class QuestionErrorDisplayer
    implements Runnable {
        private AbstractUIProcessHandler uiHandler;
        private boolean toBeContinued = true;

        QuestionErrorDisplayer(AbstractUIProcessHandler uiHandler) {
            this.uiHandler = uiHandler;
        }

        @Override
        public void run() {
            if (this.uiHandler.askQuestion("Process execution failed", "Continue anyway?", 37, 47) == 49) {
                this.mustContinue(false);
            }
        }

        public synchronized boolean shouldContinue() {
            return this.toBeContinued;
        }

        public synchronized void mustContinue(boolean toBeContinued) {
            this.toBeContinued = toBeContinued;
        }
    }

    private static class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List<String> myArguments;
        protected AbstractUIProcessHandler myHandler;

        public ExecutableClass(String className, List<String> args) {
            this.myClassName = className;
            this.myArguments = args;
        }

        @Override
        public boolean run(AbstractUIProcessHandler aHandler, Variables variables) {
            boolean result;
            block19: {
                result = false;
                this.myHandler = aHandler;
                String[] params = new String[this.myArguments.size()];
                int i = 0;
                for (String myArgument : this.myArguments) {
                    params[i] = variables.replace(myArgument);
                    ++i;
                }
                try {
                    ClassLoader loader = this.getClass().getClassLoader();
                    Class<?> procClass = loader.loadClass(this.myClassName);
                    Object instance = procClass.newInstance();
                    Method method = procClass.getMethod("run", AbstractUIProcessHandler.class, String[].class);
                    if (method.getReturnType().getName().equals("boolean")) {
                        result = (Boolean)method.invoke(instance, this.myHandler, params);
                    } else {
                        method.invoke(instance, this.myHandler, params);
                        result = true;
                    }
                }
                catch (SecurityException e) {
                    this.myHandler.emitError("Post Processing Error", "Security exception thrown when processing class: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Security exception thrown when processing class: " + this.myClassName, e);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.myHandler.emitError("Post Processing Error", "Cannot find processing class: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Cannot find processing class: " + this.myClassName, e);
                    }
                }
                catch (NoSuchMethodException e) {
                    this.myHandler.emitError("Post Processing Error", "Processing class does not have 'run' method: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Processing class does not have 'run' method: " + this.myClassName, e);
                    }
                }
                catch (IllegalAccessException e) {
                    this.myHandler.emitError("Post Processing Error", "Error accessing processing class: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Error accessing processing class: " + this.myClassName, e);
                    }
                }
                catch (InvocationTargetException e) {
                    this.myHandler.emitError("Post Processing Error", "Invocation Problem calling: " + this.myClassName + ", " + e.getCause().getMessage());
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Invocation Problem calling: " + this.myClassName, e);
                    }
                }
                catch (Exception e) {
                    this.myHandler.emitError("Post Processing Error", "Exception when running processing class: " + this.myClassName + ", " + e.getMessage());
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Exception when running processing class: " + this.myClassName, e);
                    }
                }
                catch (Error e) {
                    this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + e.getMessage());
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Error when running processing class: " + this.myClassName, e);
                    }
                }
                catch (Throwable e) {
                    this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + e.getMessage());
                    if (!Debug.isSTACKTRACE()) break block19;
                    logger.log(Level.SEVERE, "Error when running processing class: " + this.myClassName, e);
                }
            }
            return result;
        }
    }

    private class ExecutableFile
    implements Processable {
        private String filename;
        private String workingDir;
        private List<String> arguments;
        private List<String> envvariables;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String fn, List<String> args, List<String> envvars, String workingDir) {
            this.filename = fn;
            this.arguments = args;
            this.envvariables = envvars;
            this.workingDir = workingDir;
        }

        @Override
        public boolean run(AbstractUIProcessHandler handler, Variables variables) {
            this.handler = handler;
            ArrayList<String> params = new ArrayList<String>(this.arguments.size() + 1);
            try {
                params.add(variables.replace(this.filename));
            }
            catch (Exception e) {
                params.add(this.filename);
            }
            for (String argument : this.arguments) {
                try {
                    params.add(variables.replace(argument));
                }
                catch (Exception e) {
                    params.add(argument);
                }
            }
            ProcessBuilder processBuilder = new ProcessBuilder(params);
            if (this.workingDir != null && !this.workingDir.equals("")) {
                this.workingDir = IoHelper.translatePath(this.workingDir, variables);
                processBuilder.directory(new File(this.workingDir));
            }
            Map<String, String> environment = processBuilder.environment();
            for (String envvar : this.envvariables) {
                String ev = variables.replace(envvar);
                int i = ev.indexOf("=");
                if (i <= 0) continue;
                environment.put(ev.substring(0, i), ev.substring(i + 1));
            }
            try {
                Process process = processBuilder.start();
                OutputMonitor stdoutMon = new OutputMonitor(this.handler, process.getInputStream(), false);
                OutputMonitor stderrMon = new OutputMonitor(this.handler, process.getErrorStream(), true);
                Thread stdoutThread = new Thread(stdoutMon);
                Thread stderrThread = new Thread(stderrMon);
                stdoutThread.setDaemon(true);
                stderrThread.setDaemon(true);
                stdoutThread.start();
                stderrThread.start();
                try {
                    int exitStatus = process.waitFor();
                    this.stopMonitor(stdoutMon, stdoutThread);
                    this.stopMonitor(stderrMon, stderrThread);
                    if (exitStatus != 0) {
                        QuestionErrorDisplayer myErrorAlter = new QuestionErrorDisplayer(handler);
                        SwingUtilities.invokeAndWait(myErrorAlter);
                        return myErrorAlter.shouldContinue();
                    }
                }
                catch (InvocationTargetException ex) {
                    process.destroy();
                    this.handler.emitError("process interrupted", ex.toString());
                    return false;
                }
                catch (InterruptedException ie) {
                    process.destroy();
                    this.handler.emitError("process interrupted", ie.toString());
                    return false;
                }
            }
            catch (IOException ioe) {
                this.handler.emitError("I/O error", ioe.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor monitor, Thread thread) {
            monitor.doStop();
            long softTimeout = 500L;
            try {
                thread.join(softTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!thread.isAlive()) {
                return;
            }
            thread.interrupt();
            long hardTimeout = 500L;
            try {
                thread.join(hardTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = false;

            public OutputMonitor(AbstractUIProcessHandler handler, InputStream is, boolean stderr) {
                this.stderr = stderr;
                this.reader = new BufferedReader(new InputStreamReader(is));
                this.handler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        this.handler.logOutput(line, this.stderr);
                        if (ProcessPanelWorker.this.logfile != null) {
                            ProcessPanelWorker.this.logfile.println(line);
                        }
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    this.handler.logOutput(ioe.toString(), true);
                    if (ProcessPanelWorker.this.logfile == null) return;
                    ProcessPanelWorker.this.logfile.println(ioe.toString());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = true;
                }
            }
        }
    }

    private static class ProcessingJob
    implements Processable {
        public String name;
        private List<Processable> processables;

        public ProcessingJob(String name, List<Processable> processables) {
            this.name = name;
            this.processables = processables;
        }

        @Override
        public boolean run(AbstractUIProcessHandler handler, Variables variables) {
            for (Processable processable : this.processables) {
                if (processable.run(handler, variables)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, Variables var2);
    }
}

