/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.process;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.panels.process.ProcessPanelWorker;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.PrintWriter;
import java.util.Properties;

public class ProcessConsolePanel
extends AbstractConsolePanel
implements ConsolePanel,
AbstractUIProcessHandler {
    private RulesEngine rules;
    private Resources resources;
    private Prompt prompt;
    private PromptUIHandler handler;
    private final PlatformModelMatcher matcher;
    private int noOfJobs = 0;
    private int currentJob = 0;

    public ProcessConsolePanel(RulesEngine rules, Resources resources, Prompt prompt, PlatformModelMatcher matcher, PanelView<ConsolePanel> panel) {
        super(panel);
        this.rules = rules;
        this.resources = resources;
        this.prompt = prompt;
        this.handler = new PromptUIHandler(prompt);
        this.matcher = matcher;
    }

    @Override
    public void emitNotification(String message) {
        this.handler.emitNotification(message);
    }

    @Override
    public boolean emitWarning(String title, String message) {
        return this.handler.emitWarning(title, message);
    }

    @Override
    public void emitError(String title, String message) {
        this.handler.emitError(title, message);
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        this.emitError(title, message);
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return this.handler.askQuestion(title, question, choices);
    }

    @Override
    public int askQuestion(String title, String question, int choices, int default_choice) {
        return this.handler.askQuestion(title, question, choices, default_choice);
    }

    @Override
    public int askWarningQuestion(String title, String question, int choices, int default_choice) {
        return 0;
    }

    @Override
    public void logOutput(String message, boolean stderr) {
        if (stderr) {
            this.prompt.message(Prompt.Type.ERROR, message);
        } else {
            this.prompt.message(Prompt.Type.INFORMATION, message);
        }
    }

    @Override
    public void startProcessing(int no_of_processes) {
        this.logOutput("[ Starting processing ]", false);
        this.noOfJobs = no_of_processes;
    }

    @Override
    public void startProcess(String name) {
        ++this.currentJob;
        this.logOutput("Starting process " + name + " (" + Integer.toString(this.currentJob) + "/" + Integer.toString(this.noOfJobs) + ")", false);
    }

    @Override
    public void finishProcess() {
    }

    @Override
    public void finishProcessing(boolean unlockPrev, boolean unlockNext) {
    }

    @Override
    public boolean generateProperties(InstallData installData, PrintWriter printWriter) {
        return false;
    }

    @Override
    public boolean run(InstallData installData, Properties p) {
        return this.run(installData);
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        return this.run(installData);
    }

    private boolean run(InstallData installData) {
        ProcessPanelWorker worker = new ProcessPanelWorker(installData, this.rules, this.resources, this.matcher);
        worker.setHandler(this);
        worker.run();
        return worker.getResult();
    }
}

