/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.XMLException;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Messages;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocaleDatabase
extends TreeMap<String, String>
implements Messages {
    @Deprecated
    public static final String LOCALE_DATABASE_DIRECTORY = "/langpacks/";
    @Deprecated
    public static final String LOCALE_DATABASE_DEF_SUFFIX = ".xml";
    private static final char TEMP_QUOTING_CHARACTER = '\uffff';
    private final Messages parent;
    private final Locales locales;
    private static final Logger logger = Logger.getLogger(LocaleDatabase.class.getName());

    public LocaleDatabase(InputStream in, Locales locales) {
        this(in, null, locales);
    }

    public LocaleDatabase(Messages parent, Locales locales) {
        this(null, parent, locales);
    }

    public LocaleDatabase(InputStream in, Messages parent, Locales locales) {
        this.parent = parent;
        this.locales = locales;
        if (in != null) {
            this.add(in);
        }
    }

    public void add(InputStream in) {
        IXMLElement data;
        try {
            XMLParser parser = new XMLParser();
            data = parser.parse(in);
        }
        catch (XMLException exception) {
            throw new ResourceException("Failed to read langpack stream", exception);
        }
        if (!"langpack".equalsIgnoreCase(data.getElement().getLocalName())) {
            throw new ResourceException("Invalid IzPack XML langpack file");
        }
        for (IXMLElement child : data.getChildren()) {
            String text = child.getContent();
            if (text != null && !"".equals(text)) {
                this.put(child.getAttribute("id"), text.trim());
                continue;
            }
            this.put(child.getAttribute("id"), child.getAttribute("txt"));
        }
    }

    @Override
    public String get(Object id) {
        String result = (String)super.get(id);
        return result != null ? result : id.toString();
    }

    @Override
    public String get(String id, Object ... args) {
        String result;
        String pattern;
        String string = pattern = id != null ? (String)super.get(id) : null;
        if (pattern != null) {
            if (args.length > 0) {
                try {
                    pattern = pattern.replace('\'', '\uffff');
                    pattern = MessageFormat.format(pattern, args);
                    result = MessageFormat.format(pattern, args);
                    result = result.replace('\uffff', '\'');
                }
                catch (IllegalArgumentException exception) {
                    result = id;
                    logger.log(Level.WARNING, "Failed to format pattern=" + pattern + ", for key=" + id, exception);
                }
            } else {
                result = pattern;
            }
        } else {
            result = this.parent != null ? this.parent.get(id, args) : id;
        }
        return result;
    }

    @Override
    public void add(Messages messages) {
        this.putAll(messages.getMessages());
    }

    @Override
    public Map<String, String> getMessages() {
        return Collections.unmodifiableMap(this);
    }

    @Override
    public Messages newMessages(String name) {
        Messages child = this.locales.getMessages(name);
        LocaleDatabase result = new LocaleDatabase(this, this.locales);
        result.add(child);
        return result;
    }

    @Deprecated
    public String getString(String key) {
        String val = this.get(key);
        if (val == null) {
            val = key;
        }
        return val;
    }

    public String getString(String key, String[] variables) {
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i] == null) {
                variables[i] = "N/A";
                continue;
            }
            if (!variables[i].startsWith("$")) continue;
            String curArg = variables[i];
            curArg = curArg.startsWith("${") ? curArg.substring(2, curArg.length() - 1) : curArg.substring(1);
            variables[i] = this.get(curArg);
        }
        String message = this.get(key);
        message = message.replace('\'', '\uffff');
        message = MessageFormat.format(message, variables);
        return message.replace('\uffff', '\'');
    }
}

