/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.console.pages;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

/**
 * Error WebPage.
 */
public class ErrorPage extends BasePage {

    private static final long serialVersionUID = -390761262038796657L;

    public ErrorPage(final PageParameters parameters) {
        super(parameters);

        add(new Label("errorTitle", new Model<String>(parameters.get("errorTitle").toString())));
        add(new Label("errorMessage", new Model<String>(parameters.get("errorMessage").toString())));

        add(new BookmarkablePageLink<Page>("home", getApplication().getHomePage()));
    }
}
