/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.snmp;

import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;

public class SynapseMIBUtils {
    private static final String PROPERTY_CONNECTOR_NAME = "ConnectorName";
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_TYPE = "Type";
    private static final Map<String, Integer> type2oid = new HashMap<String, Integer>();
    private static final Map<String, Integer> name2oid = new HashMap<String, Integer>();

    public static synchronized String getOID(ObjectName objectName) {
        String name;
        String type = objectName.getKeyProperty(PROPERTY_TYPE);
        Integer typeOID = type2oid.get(type);
        if (typeOID == null) {
            return null;
        }
        if ("Transport".equals(type)) {
            String connector = objectName.getKeyProperty(PROPERTY_CONNECTOR_NAME);
            name = connector.substring(0, connector.lastIndexOf(45));
        } else {
            name = objectName.getKeyProperty(PROPERTY_NAME);
        }
        if (name != null) {
            Integer nameOID = name2oid.get(name);
            if (nameOID == null) {
                nameOID = new Integer(name2oid.size() + 1);
                name2oid.put(name, nameOID);
            }
            return "1.3.6.1.4.1.18060.14." + typeOID + "." + nameOID;
        }
        return "1.3.6.1.4.1.18060.14." + typeOID;
    }

    static {
        type2oid.put("ServerManager", 1);
        type2oid.put("Transport", 2);
        type2oid.put("NhttpConnections", 3);
        type2oid.put("NHTTPLatencyView", 4);
        type2oid.put("NHTTPS2SLatencyView", 5);
        name2oid.put("nio-http-listener", 1);
        name2oid.put("nio-http-sender", 2);
        name2oid.put("nio-https-listener", 3);
        name2oid.put("nio-https-sender", 4);
        name2oid.put("jms-listener", 5);
        name2oid.put("jms-sender", 6);
        name2oid.put("vfs-listener", 7);
        name2oid.put("vfs-sender", 8);
        name2oid.put("mailto-listener", 9);
        name2oid.put("mailto-sender", 10);
        name2oid.put("http-listener", 11);
        name2oid.put("http-sender", 12);
        name2oid.put("https-listener", 13);
        name2oid.put("https-sender", 14);
        name2oid.put("nio-http", 15);
        name2oid.put("nio-https", 16);
    }
}

