/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceFinder;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceRepository;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.commons.util.RMIRegistryController;

public class JNDIBasedDataSourceRepository
implements DataSourceRepository {
    private static Log log = LogFactory.getLog(JNDIBasedDataSourceRepository.class);
    private InitialContext initialContext;
    private Properties jndiProperties;
    private final Map<String, InitialContext> perDataSourceICMap = new HashMap<String, InitialContext>();
    private final List<String> cachedNameList = new ArrayList<String>();
    private final List<Integer> cachedPorts = new ArrayList<Integer>();
    private boolean initialized = false;

    @Override
    public void init(Properties jndiEnv) {
        this.initialized = true;
        if (jndiEnv == null || jndiEnv.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided global JNDI environment properties is empty or null.");
            }
            return;
        }
        if (this.isValid(jndiEnv)) {
            this.jndiProperties = this.createJNDIEnvironment(jndiEnv, null);
            this.initialContext = this.createInitialContext(this.jndiProperties);
        }
    }

    @Override
    public void register(DataSourceInformation information) {
        this.validateInitialized();
        String dataSourceName = information.getDatasourceName();
        this.validateDSName(dataSourceName);
        Properties properties = information.getProperties();
        InitialContext context = null;
        Properties jndiEvn = null;
        if ((properties == null || properties.isEmpty()) && this.initialContext != null) {
            context = this.initialContext;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Empty JNDI properties for datasource " + dataSourceName));
                log.debug((Object)("Using system-wide jndi properties : " + this.jndiProperties));
            }
            jndiEvn = this.jndiProperties;
        }
        if (context == null) {
            jndiEvn = this.createJNDIEnvironment(properties, information.getAlias());
            context = this.createInitialContext(jndiEvn);
            if (context == null) {
                this.validateInitialContext(this.initialContext);
                context = this.initialContext;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot create a name context with provided jndi properties : " + jndiEvn));
                    log.debug((Object)("Using system-wide JNDI properties : " + this.jndiProperties));
                }
                jndiEvn = this.jndiProperties;
            } else {
                this.perDataSourceICMap.put(dataSourceName, context);
            }
        }
        String dsType = information.getType();
        String driver = information.getDriver();
        String url = information.getUrl();
        String user = information.getSecretInformation().getUser();
        String password = information.getSecretInformation().getResolvedSecret();
        String maxActive = String.valueOf(information.getMaxActive());
        String maxIdle = String.valueOf(information.getMaxIdle());
        String maxWait = String.valueOf(information.getMaxWait());
        JNDIBasedDataSourceRepository.populateContextTree(context, dataSourceName);
        if ("BasicDataSource".equals(dsType)) {
            Reference ref = new Reference("javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory", null);
            ref.add(new StringRefAddr("driverClassName", driver));
            ref.add(new StringRefAddr("url", url));
            ref.add(new StringRefAddr("username", user));
            ref.add(new StringRefAddr("password", password));
            ref.add(new StringRefAddr("maxActive", maxActive));
            ref.add(new StringRefAddr("maxIdle", maxIdle));
            ref.add(new StringRefAddr("maxWait", maxWait));
            JNDIBasedDataSourceRepository.setBasicDataSourceParameters(ref, information);
            JNDIBasedDataSourceRepository.setCommonParameters(ref, information);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registering a DataSource with name : " + dataSourceName + " in the JNDI tree with jndiProperties : " + jndiEvn));
                }
                context.rebind(dataSourceName, (Object)ref);
            }
            catch (NamingException e) {
                String msg = " Error binding name ' " + dataSourceName + " ' to " + "the DataSource(BasicDataSource) reference";
                throw new SynapseCommonsException(msg, e, log);
            }
        }
        if ("PerUserPoolDataSource".equals(dsType)) {
            String className = (String)information.getParameter("cpdsadapter.className");
            String factory = (String)information.getParameter("cpdsadapter.factory");
            String name = (String)information.getParameter("cpdsadapter.name");
            Reference cpdsRef = new Reference(className, factory, null);
            cpdsRef.add(new StringRefAddr("driver", driver));
            cpdsRef.add(new StringRefAddr("url", url));
            cpdsRef.add(new StringRefAddr("user", user));
            cpdsRef.add(new StringRefAddr("password", password));
            try {
                context.rebind(name, (Object)cpdsRef);
            }
            catch (NamingException e) {
                String msg = "Error binding name '" + name + "' to " + "the DriverAdapterCPDS reference";
                throw new SynapseCommonsException(msg, e, log);
            }
            Reference ref = new Reference("org.apache.commons.dbcp.datasources.PerUserPoolDataSource", "org.apache.commons.dbcp.datasources.PerUserPoolDataSourceFactory", null);
            ref.add(new BinaryRefAddr("jndiEnvironment", MiscellaneousUtil.serialize(jndiEvn)));
            ref.add(new StringRefAddr("dataSourceName", name));
            ref.add(new StringRefAddr("defaultMaxActive", maxActive));
            ref.add(new StringRefAddr("defaultMaxIdle", maxIdle));
            ref.add(new StringRefAddr("defaultMaxWait", maxWait));
            JNDIBasedDataSourceRepository.setCommonParameters(ref, information);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registering a DataSource with name : " + dataSourceName + " in the JNDI tree with jndiProperties : " + jndiEvn));
                }
                context.rebind(dataSourceName, (Object)ref);
            }
            catch (NamingException e) {
                String msg = "Error binding name ' " + dataSourceName + " ' to " + "the PerUserPoolDataSource reference";
                throw new SynapseCommonsException(msg, e, log);
            }
        }
        throw new SynapseCommonsException("Unsupported data source type : " + dsType, log);
        this.cachedNameList.add(dataSourceName);
    }

    @Override
    public void unRegister(String name) {
        InitialContext context = this.getCachedInitialContext(name);
        try {
            context.unbind(name);
        }
        catch (NamingException e) {
            throw new SynapseCommonsException("Error removing a Datasource with name : " + name + " from the JNDI context : " + this.initialContext, e);
        }
        this.cachedNameList.remove(name);
    }

    @Override
    public DataSource lookUp(String dsName) {
        this.validateInitialized();
        this.validateDSName(dsName);
        if (!this.cachedNameList.contains(dsName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no Datasource with name " + dsName + " in JNDI Datasource Repository"));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting a DataSource with name : " + dsName + " from the JNDI tree."));
        }
        InitialContext context = this.getCachedInitialContext(dsName);
        return DataSourceFinder.find(dsName, context);
    }

    @Override
    public void clear() {
        this.initialized = false;
        this.initialContext = null;
        this.jndiProperties.clear();
        this.perDataSourceICMap.clear();
        this.cachedNameList.clear();
        for (int port : this.cachedPorts) {
            RMIRegistryController.getInstance().removeLocalRegistry(port);
        }
        this.cachedPorts.clear();
    }

    private InitialContext getCachedInitialContext(String name) {
        InitialContext context = this.perDataSourceICMap.get(name);
        if (context == null) {
            this.validateInitialContext(this.initialContext);
            context = this.initialContext;
        }
        return context;
    }

    private static void setCommonParameters(Reference reference, DataSourceInformation information) {
        reference.add(new StringRefAddr("defaultAutoCommit", String.valueOf(information.isDefaultAutoCommit())));
        reference.add(new StringRefAddr("defaultReadOnly", String.valueOf(information.isDefaultReadOnly())));
        reference.add(new StringRefAddr("testOnBorrow", String.valueOf(information.isTestOnBorrow())));
        reference.add(new StringRefAddr("testOnReturn", String.valueOf(information.isTestOnReturn())));
        reference.add(new StringRefAddr("timeBetweenEvictionRunsMillis", String.valueOf(information.getTimeBetweenEvictionRunsMillis())));
        reference.add(new StringRefAddr("numTestsPerEvictionRun", String.valueOf(information.getNumTestsPerEvictionRun())));
        reference.add(new StringRefAddr("minEvictableIdleTimeMillis", String.valueOf(information.getMinEvictableIdleTimeMillis())));
        reference.add(new StringRefAddr("testWhileIdle", String.valueOf(information.isTestWhileIdle())));
        String validationQuery = information.getValidationQuery();
        if (validationQuery != null && !"".equals(validationQuery)) {
            reference.add(new StringRefAddr("validationQuery", validationQuery));
        }
    }

    private static void setBasicDataSourceParameters(Reference ref, DataSourceInformation information) {
        int defaultTransactionIsolation = information.getDefaultTransactionIsolation();
        String defaultCatalog = information.getDefaultCatalog();
        if (defaultTransactionIsolation != -1) {
            ref.add(new StringRefAddr("defaultTransactionIsolation", String.valueOf(defaultTransactionIsolation)));
        }
        ref.add(new StringRefAddr("minIdle", String.valueOf(information.getMaxIdle())));
        ref.add(new StringRefAddr("accessToUnderlyingConnectionAllowed", String.valueOf(information.isAccessToUnderlyingConnectionAllowed())));
        ref.add(new StringRefAddr("removeAbandoned", String.valueOf(information.isRemoveAbandoned())));
        ref.add(new StringRefAddr("removeAbandonedTimeout", String.valueOf(information.getRemoveAbandonedTimeout())));
        ref.add(new StringRefAddr("logAbandoned", String.valueOf(information.isLogAbandoned())));
        ref.add(new StringRefAddr("poolPreparedStatements", String.valueOf(information.isPoolPreparedStatements())));
        ref.add(new StringRefAddr("maxOpenPreparedStatements", String.valueOf(information.getMaxOpenPreparedStatements())));
        ref.add(new StringRefAddr("initialSize", String.valueOf(information.getInitialSize())));
        if (defaultCatalog != null && !"".equals(defaultCatalog)) {
            ref.add(new StringRefAddr("defaultCatalog", defaultCatalog));
        }
    }

    private static void populateContextTree(InitialContext initialContext, String path) {
        String[] paths = path.split("/");
        if (paths != null && paths.length > 1) {
            Context context = initialContext;
            for (String path1 : paths) {
                try {
                    assert (context != null);
                    if ((context = context.createSubcontext(path1)) != null) continue;
                    throw new SynapseCommonsException("sub context " + path1 + " could not" + " be created", log);
                }
                catch (NamingException e) {
                    throw new SynapseCommonsException("Unable to create sub context : " + path1, e, log);
                }
            }
        }
    }

    private Properties createJNDIEnvironment(Properties dsProperties, String name) {
        String namingFactory = "com.sun.jndi.rmi.registry.RegistryContextFactory";
        String providerUrl = null;
        int port = 2199;
        String providerPort = null;
        Properties jndiEvn = new Properties();
        if (dsProperties != null && !dsProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using properties " + dsProperties + " to create JNDI Environment"));
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("synapse.datasources");
            buffer.append(".");
            if (name != null && !"".equals(name)) {
                buffer.append(name);
                buffer.append(".");
            }
            String rootPrefix = buffer.toString();
            namingFactory = MiscellaneousUtil.getProperty(dsProperties, rootPrefix + "icFactory", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            providerUrl = MiscellaneousUtil.getProperty(dsProperties, rootPrefix + "providerUrl", null);
            providerPort = MiscellaneousUtil.getProperty(dsProperties, rootPrefix + "providerPort", String.valueOf(2199));
        }
        jndiEvn.put("java.naming.factory.initial", namingFactory);
        if (providerUrl != null && !"".equals(providerUrl)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using provided initial context provider url :" + providerUrl));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No initial context provider url...creaeting a new one");
            }
            String providerHost = "localhost";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                if (addr != null) {
                    String hostname = addr.getHostName();
                    if (hostname == null) {
                        String ipAddr = addr.getHostAddress();
                        if (ipAddr != null) {
                            providerHost = ipAddr;
                        }
                    } else {
                        providerHost = hostname;
                    }
                }
            }
            catch (UnknownHostException e) {
                log.warn((Object)"Unable to determine hostname or IP address.. Using localhost", (Throwable)e);
            }
            if (providerPort != null) {
                try {
                    port = Integer.parseInt(providerPort);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            RMIRegistryController.getInstance().createLocalRegistry(port);
            this.cachedPorts.add(port);
            providerUrl = "rmi://" + providerHost + ":" + port;
        }
        jndiEvn.put("java.naming.provider.url", providerUrl);
        log.info((Object)("DataSources will be registered in the JNDI context with provider PROP_URL : " + providerUrl));
        return jndiEvn;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private void validateInitialized() {
        if (!this.isInitialized()) {
            throw new SynapseCommonsException("Datasource repository has not been initialized yet", log);
        }
    }

    private void validateDSName(String dataSourceName) {
        if (dataSourceName == null || "".equals(dataSourceName)) {
            throw new SynapseCommonsException("Invalid DataSource configuration !! -DataSource Name cannot be found ", log);
        }
    }

    private void validateInitialContext(InitialContext initialContext) {
        if (initialContext == null) {
            throw new SynapseCommonsException("InitialContext cannot be found.", log);
        }
    }

    private InitialContext createInitialContext(Properties jndiEnv) {
        if (jndiEnv == null || jndiEnv.isEmpty()) {
            return null;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initiating a Naming context with JNDI environment jndiProperties :  " + jndiEnv));
            }
            return new InitialContext(jndiEnv);
        }
        catch (NamingException e) {
            throw new SynapseCommonsException("Error creating a InitialContext with JNDI env jndiProperties : " + jndiEnv, log);
        }
    }

    private boolean isValid(Properties dsProperties) {
        String dataSources = MiscellaneousUtil.getProperty(dsProperties, "synapse.datasources", null);
        if (dataSources != null && !"".equals(dataSources)) {
            String[] dataSourcesNames = dataSources.split(",");
            return dataSourcesNames != null && dataSourcesNames.length != 0;
        }
        return false;
    }
}

