/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.beanstalk.enterprise;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.beanstalk.enterprise.CacheEntry;
import org.apache.synapse.commons.beanstalk.enterprise.EnterpriseBeanstalkView;
import org.apache.synapse.commons.jmx.MBeanRegistrar;

public class EnterpriseBeanstalk {
    private static final Log log = LogFactory.getLog(EnterpriseBeanstalk.class);
    private String name;
    private Properties props;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledFuture;
    private int statelessBeanTimeoutMinutes = 30;
    private int statefulBeanTimeoutMinutes = 30;
    private int statelessBeanWarnLimit = Short.MAX_VALUE;
    private int statefulBeanWarnLimit = Short.MAX_VALUE;
    private InitialContext initialCtx;
    private Map<String, CacheEntry> statelessBeans = new ConcurrentHashMap<String, CacheEntry>();
    private Map<String, CacheEntry> statefulBeans = new ConcurrentHashMap<String, CacheEntry>();

    public EnterpriseBeanstalk(String name, Properties props, ScheduledExecutorService scheduler) {
        this.name = name;
        this.scheduler = scheduler;
        this.props = props;
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing Beanstalk: " + this.name));
        }
        try {
            this.initialCtx = new InitialContext(this.props);
        }
        catch (NamingException e) {
            log.error((Object)("Could not initialize JNDI context for the Enterprise Beanstalk named '" + this.name + "'."), (Throwable)e);
            return;
        }
        if (this.props != null) {
            String value = this.props.getProperty("cache.timeout.stateless");
            if (value != null) {
                this.statelessBeanTimeoutMinutes = Integer.parseInt(value);
            }
            if ((value = this.props.getProperty("cache.timeout.stateful")) != null) {
                this.statefulBeanTimeoutMinutes = Integer.parseInt(value);
            }
            if ((value = this.props.getProperty("cache.warn.limit.stateless")) != null) {
                this.statelessBeanWarnLimit = Integer.parseInt(value);
            }
            if ((value = this.props.getProperty("cache.warn.limit.stateful")) != null) {
                this.statefulBeanWarnLimit = Integer.parseInt(value);
            }
        }
        int minDelay = Math.min(this.statelessBeanTimeoutMinutes, this.statefulBeanTimeoutMinutes);
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                EnterpriseBeanstalk.this.removeExpiredBeans();
            }
        }, minDelay, minDelay, TimeUnit.MINUTES);
        MBeanRegistrar.getInstance().registerMBean(new EnterpriseBeanstalkView(this), "EnterpriseBeanstalk", this.name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully initialized Beanstalk: " + this.name));
        }
    }

    public void destroy() {
        this.scheduledFuture.cancel(false);
        MBeanRegistrar.getInstance().unRegisterMBean("EnterpriseBeanstalk", this.name);
    }

    public String getName() {
        return this.name;
    }

    public Object getEnterpriseBean(String className, String sessionId, String jndiName) {
        return sessionId == null ? this.findEjb(this.statelessBeans, className, sessionId, jndiName, this.statelessBeanWarnLimit) : this.findEjb(this.statefulBeans, className, sessionId, jndiName, this.statefulBeanWarnLimit);
    }

    public Object removeEnterpriseBean(String className, String sessionId) {
        return sessionId == null ? this.statelessBeans.remove(this.getMapKey(className, sessionId)) : this.statefulBeans.remove(this.getMapKey(className, sessionId));
    }

    public void removeExpiredBeans() {
        this.removeExpiredBeansFromMap(this.statelessBeans, this.statelessBeanTimeoutMinutes);
        this.removeExpiredBeansFromMap(this.statefulBeans, this.statefulBeanTimeoutMinutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findEjb(Map<String, CacheEntry> map, String className, String sessionId, String jndiName, int warnLimit) {
        CacheEntry entry = map.get(this.getMapKey(className, sessionId));
        if (entry == null && jndiName != null) {
            EnterpriseBeanstalk enterpriseBeanstalk = this;
            synchronized (enterpriseBeanstalk) {
                Object ejb;
                entry = map.get(this.getMapKey(className, sessionId));
                if (entry == null && (ejb = this.lookupInJndi(jndiName)) != null) {
                    entry = new CacheEntry(ejb);
                    map.put(this.getMapKey(className, sessionId), entry);
                    int size = map.size();
                    if (size > warnLimit) {
                        String type = sessionId == null ? "stateless" : "stateful";
                        log.warn((Object)("Warn limit reached for " + type + " beans. Currently there " + "are " + size + " " + type + " EJB stubs cached in '" + this.name + "' " + "beanstalk."));
                    }
                }
            }
        }
        if (entry == null) {
            return null;
        }
        entry.markLastAccessTime();
        return entry.getBean();
    }

    private Object lookupInJndi(String jndiName) {
        try {
            return this.initialCtx.lookup(jndiName);
        }
        catch (NamingException ex) {
            log.error((Object)("Lookup failed for JNDI name: " + jndiName), (Throwable)ex);
            return null;
        }
    }

    private void removeExpiredBeansFromMap(Map<String, CacheEntry> map, int timeoutInMinutes) {
        Iterator<Map.Entry<String, CacheEntry>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, CacheEntry> mapEntry = itr.next();
            if (System.currentTimeMillis() - mapEntry.getValue().getLastAccessTime() <= (long)timeoutInMinutes * 60L * 1000L) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing the timed-out EJB stub with key '" + mapEntry.getKey() + "', from '" + this.name + "' beanstalk cache."));
            }
            itr.remove();
        }
    }

    private String getMapKey(String className, String sessionId) {
        return sessionId == null ? className : className + "-" + sessionId;
    }

    Map<String, CacheEntry> getStatelessBeans() {
        return this.statelessBeans;
    }

    Map<String, CacheEntry> getStatefulBeans() {
        return this.statefulBeans;
    }
}

