/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.experimental.mediators.seda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.experimental.mediators.seda.SEDAQueue;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueConsumer;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueConsumerPolicy;

public class SEDAQueueConsumerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(SEDAQueueConsumerWorker.class);
    private final SEDAQueueConsumerPolicy queueConsumerPolicy;
    private final SEDAQueue sedaQueue;
    private final BlockingQueue<MessageContext> queue;
    private final SEDAQueueConsumer sedaQueueConsumer;

    public SEDAQueueConsumerWorker(SEDAQueue sedaQueue, SEDAQueueConsumerPolicy queueConsumerPolicy, SEDAQueueConsumer sedaQueueConsumer) {
        this.sedaQueue = sedaQueue;
        this.queueConsumerPolicy = queueConsumerPolicy;
        this.queue = sedaQueue.getQueue();
        this.sedaQueueConsumer = sedaQueueConsumer;
    }

    @Override
    public void run() {
        String action = this.queueConsumerPolicy.getAction();
        if ("take".equals(action)) {
            try {
                this.consume(this.queue.take());
            }
            catch (InterruptedException ignored) {
                log.debug((Object)"Ignored InterruptedException when ocuured calling queue.take()");
            }
        } else if ("poll".equals(action)) {
            long timeout = this.queueConsumerPolicy.getTimeoutOnPoll();
            if (timeout < 0L) {
                this.consume((MessageContext)this.queue.poll());
            } else {
                try {
                    this.consume(this.queue.poll(timeout, TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException ignored) {
                    log.debug((Object)"Ignored InterruptedException when ocuured calling queue.poll()");
                }
            }
        } else if ("drain".equals(action)) {
            int maxElements = this.queueConsumerPolicy.getMaxElementsOnPoll();
            ArrayList<MessageContext> contexts = new ArrayList<MessageContext>(maxElements);
            this.queue.drainTo(contexts, maxElements);
            this.consume(contexts);
        } else if ("drainAll".equals(action)) {
            ArrayList<MessageContext> contexts = new ArrayList<MessageContext>();
            this.queue.drainTo(contexts);
            this.consume(contexts);
        }
    }

    private void consume(MessageContext context) {
        if (context != null) {
            this.sedaQueueConsumer.consume(context);
        }
    }

    private void consume(Collection<MessageContext> contexts) {
        for (MessageContext context : contexts) {
            this.consume(context);
        }
    }
}

