/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.FilterMediator;

public class InMediator
extends AbstractListMediator
implements FilterMediator {
    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : In mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        boolean result = true;
        if (this.test(synCtx)) {
            synLog.traceOrDebug("Current message is incoming - executing child mediators");
            result = super.mediate(synCtx);
        } else {
            synLog.traceOrDebug("Current message is a response - skipping child mediators");
        }
        synLog.traceOrDebug("End : In mediator");
        return result;
    }

    @Override
    public boolean test(MessageContext synCtx) {
        return !synCtx.isResponse();
    }

    @Override
    public boolean isContentAware() {
        return false;
    }
}

