/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.MessageProcessorFactory;
import org.apache.synapse.config.xml.MessageProcessorSerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.message.processors.MessageProcessor;

public class MessageProcessorDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(MessageProcessorDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message Processor Deployment from file : " + fileName + " : Started"));
        }
        try {
            MessageProcessor mp = MessageProcessorFactory.createMessageProcessor(artifactConfig);
            if (mp != null) {
                mp.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message Processor named '" + mp.getName() + "' has been built from the file " + fileName));
                }
                if (this.getSynapseConfiguration().getMessageStore(mp.getMessageStoreName()) != null) {
                    mp.init(this.getSynapseEnvironment());
                } else {
                    this.handleSynapseArtifactDeploymentError("Message Processor Deployment from the file :" + fileName + " : Failed. Can not create a Message processor without a Message Store");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the Message Processor : " + mp.getName()));
                }
                this.getSynapseConfiguration().addMessageProcessor(mp.getName(), mp);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message Processor Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("Message Processor named '" + mp.getName() + "' has been deployed from file : " + fileName));
                return mp.getName();
            }
            this.handleSynapseArtifactDeploymentError("Message Processor Deployment from the file : " + fileName + " : Failed. The artifact " + "described in the file  is not a Message Processor");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Message Processor Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message Processor update from file : " + fileName + " has started"));
        }
        try {
            MessageProcessor mp = MessageProcessorFactory.createMessageProcessor(artifactConfig);
            if (mp == null) {
                this.handleSynapseArtifactDeploymentError("Message Processor update failed. The artifact defined in the file: " + fileName + " is not valid");
                return null;
            }
            mp.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("MessageProcessor: " + mp.getName() + " has been built from the file: " + fileName));
            }
            MessageProcessor existingMp = this.getSynapseConfiguration().getMessageProcessors().get(existingArtifactName);
            existingMp.destroy();
            mp.init(this.getSynapseEnvironment());
            this.getSynapseConfiguration().addMessageProcessor(mp.getName(), mp);
            this.getSynapseConfiguration().removeMessageStore(existingArtifactName);
            log.info((Object)("MessageProcessor: " + existingArtifactName + " has been undeployed"));
            log.info((Object)("MessageProcessor: " + mp.getName() + " has been updated from the file: " + fileName));
            this.waitForCompletion();
            return mp.getName();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the MessageProcessor from the file: " + fileName);
            return null;
        }
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MessageProcessor Undeployment of the MessageProcessor named : " + artifactName + " : Started"));
        }
        try {
            MessageProcessor mp = this.getSynapseConfiguration().getMessageProcessors().get(artifactName);
            if (mp != null) {
                this.getSynapseConfiguration().removeMessageProcessor(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroying the MessageProcessor named : " + artifactName));
                }
                mp.destroy();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MessageProcessor Undeployment of the endpoint named : " + artifactName + " : Completed"));
                }
                log.info((Object)("MessageProcessor named '" + mp.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("MessageProcessor " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("MessageProcessor Undeployement of MessageProcessor named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the MessageProcessor with name : " + artifactName + " : Started"));
        }
        try {
            MessageProcessor mp = this.getSynapseConfiguration().getMessageProcessors().get(artifactName);
            OMElement msElem = MessageProcessorSerializer.serializeMessageProcessor(null, mp);
            if (mp.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "message-processors" + File.separator + mp.getFileName();
                this.writeToFile(msElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the MessageProcessor with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("MessageProcessor named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the MessageProcessor named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the MessageProcessor named '" + artifactName + "' has failed", e);
        }
    }
}

