/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axiom.om.OMException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.statistics.ErrorLogFactory;
import org.apache.synapse.aspects.statistics.StatisticsReporter;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.core.axis2.SynapseCallbackStoreView;
import org.apache.synapse.core.axis2.TimeoutHandler;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.util.ResponseAcceptEncodingProcessor;

public class SynapseCallbackReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(SynapseCallbackReceiver.class);
    private static final String CALLBACK_STORE_CATEGORY = "SynapseCallbackStore";
    private static final String CALLBACK_STORE_NAME = "SynapseCallbackStore";
    private static final SynapseCallbackReceiver instance = new SynapseCallbackReceiver();
    private final Map<String, AxisCallback> callbackStore = Collections.synchronizedMap(new HashMap());
    private boolean initialized = false;

    private SynapseCallbackReceiver() {
    }

    public static SynapseCallbackReceiver getInstance() {
        return instance;
    }

    public void init(SynapseConfiguration synCfg, ServerContextInformation contextInformation) {
        if (this.initialized) {
            log.warn((Object)"Attempted to re-initialize SynapseCallbackReceiver");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing SynapseCallbackReceiver");
        }
        TimeoutHandler timeoutHandler = new TimeoutHandler(this.callbackStore, contextInformation);
        Timer timeOutTimer = synCfg.getSynapseTimer();
        long timeoutHandlerInterval = SynapseConfigUtils.getTimeoutHandlerInterval();
        timeOutTimer.schedule((TimerTask)timeoutHandler, 0L, timeoutHandlerInterval);
        MBeanRegistrar.getInstance().registerMBean((Object)new SynapseCallbackStoreView(this), "SynapseCallbackStore", "SynapseCallbackStore");
        this.initialized = true;
    }

    public void destroy() {
        if (!this.initialized) {
            log.warn((Object)"Attempted to destroy uninitialized SynapseCallbackReceiver");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying SynapseCallbackReceiver");
        }
        MBeanRegistrar.getInstance().unRegisterMBean("SynapseCallbackStore", "SynapseCallbackStore");
        this.initialized = false;
    }

    public int getCallbackCount() {
        return this.callbackStore.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPendingCallbacks() {
        Set<String> keys = this.callbackStore.keySet();
        ArrayList<String> list = new ArrayList<String>();
        Map<String, AxisCallback> map = this.callbackStore;
        synchronized (map) {
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public void addCallback(String MsgID, AxisCallback callback) {
        this.callbackStore.put(MsgID, callback);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Callback added. Total callbacks waiting for : " + this.callbackStore.size()));
        }
    }

    public void receive(org.apache.axis2.context.MessageContext messageCtx) throws AxisFault {
        String messageID = null;
        if (messageCtx.getProperty("HTTP_202_RECEIVED") != null && "true".equals(messageCtx.getProperty("HTTP_202_RECEIVED"))) {
            if (this.callbackStore.containsKey(messageCtx.getMessageID())) {
                this.callbackStore.remove(messageCtx.getMessageID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallBack registered with Message id : " + messageCtx.getMessageID() + " removed from the " + "callback store since we got an accepted Notification"));
                }
            }
            return;
        }
        if (messageCtx.getOptions() != null && messageCtx.getOptions().getRelatesTo() != null) {
            RelatesTo relatesTo;
            Options options = messageCtx.getOptions();
            if (options != null && (relatesTo = options.getRelatesTo()) != null) {
                messageID = relatesTo.getValue();
            }
        } else {
            messageID = (String)messageCtx.getProperty("synapse.RelatesToForPox");
        }
        if (messageID != null) {
            RelatesTo[] relates;
            AxisCallback callback = this.callbackStore.remove(messageID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Callback removed for request message id : " + messageID + ". Pending callbacks count : " + this.callbackStore.size()));
            }
            if ((relates = messageCtx.getRelationships()) != null && relates.length > 1) {
                this.removeDuplicateRelatesTo(messageCtx, relates);
            }
            if (callback != null) {
                this.handleMessage(messageID, messageCtx, ((AsyncCallback)callback).getSynapseOutMsgCtx(), (AsyncCallback)callback);
            } else {
                log.warn((Object)("Synapse received a response for the request with message Id : " + messageID + " But a callback is not registered (anymore) to process this response"));
            }
        } else if (!messageCtx.isPropertyTrue("SC_ACCEPTED")) {
            log.warn((Object)"Synapse received a response message without a message Id");
        }
    }

    private void handleMessage(String messageID, org.apache.axis2.context.MessageContext response, MessageContext synapseOutMsgCtx, AsyncCallback callback) throws AxisFault {
        Object o = response.getProperty("SENDING_FAULT");
        if (o != null && Boolean.TRUE.equals(o)) {
            Pipe pipe = (Pipe)((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().getProperty("pass-through.pipe");
            if (pipe != null && pipe.isSerializationComplete()) {
                NHttpServerConnection conn = (NHttpServerConnection)((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().getProperty("pass-through.Source-Connection");
                SourceConfiguration sourceConfiguration = (SourceConfiguration)((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
                Pipe newPipe = new Pipe((IOControl)conn, sourceConfiguration.getBufferFactory().getBuffer(), "source", (BaseConfiguration)sourceConfiguration);
                ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().setProperty("pass-through.pipe", (Object)newPipe);
            }
            StatisticsReporter.reportFaultForAll(synapseOutMsgCtx, ErrorLogFactory.createErrorLog(response));
            Stack<FaultHandler> faultStack = synapseOutMsgCtx.getFaultStack();
            if (faultStack != null && !faultStack.isEmpty()) {
                int errorCode;
                try {
                    synapseOutMsgCtx.getEnvelope().build();
                }
                catch (OMException x) {
                    synapseOutMsgCtx.setEnvelope(response.getEnvelope());
                }
                Exception e = (Exception)response.getProperty("ERROR_EXCEPTION");
                synapseOutMsgCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
                synapseOutMsgCtx.setProperty("ERROR_CODE", response.getProperty("ERROR_CODE"));
                synapseOutMsgCtx.setProperty("ERROR_MESSAGE", response.getProperty("ERROR_MESSAGE"));
                synapseOutMsgCtx.setProperty("ERROR_DETAIL", response.getProperty("ERROR_DETAIL"));
                synapseOutMsgCtx.setProperty("ERROR_EXCEPTION", e);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[Failed Request Message ID : " + messageID + "]" + " [New to be Retried Request Message ID : " + synapseOutMsgCtx.getMessageID() + "]"));
                }
                if ((errorCode = ((Integer)response.getProperty("ERROR_CODE")).intValue()) == 101504 && callback.getTimeOutAction() == 101) {
                    log.warn((Object)("Synapse timed out for the request with Message ID : " + messageID + ". Ignoring fault handlers since the timeout action is DISCARD."));
                    faultStack.removeAllElements();
                } else {
                    faultStack.pop().handleFault(synapseOutMsgCtx, null);
                }
            }
        } else {
            Stack<FaultHandler> faultStack = synapseOutMsgCtx.getFaultStack();
            if (faultStack != null && !faultStack.isEmpty() && faultStack.peek() instanceof Endpoint) {
                Endpoint successfulEndpoint = (Endpoint)((Object)faultStack.pop());
                successfulEndpoint.onSuccess();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Synapse received an asynchronous response message");
                log.debug((Object)("Received To: " + (response.getTo() != null ? response.getTo().getAddress() : "null")));
                log.debug((Object)("SOAPAction: " + (response.getSoapAction() != null ? response.getSoapAction() : "null")));
                log.debug((Object)("WSA-Action: " + (response.getWSAAction() != null ? response.getWSAAction() : "null")));
                String[] cids = response.getAttachmentMap().getAllContentIDs();
                if (cids != null && cids.length > 0) {
                    for (String cid : cids) {
                        log.debug((Object)("Attachment : " + cid));
                    }
                }
                log.debug((Object)("Body : \n" + response.getEnvelope()));
            }
            org.apache.axis2.context.MessageContext axisOutMsgCtx = ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext();
            ResponseAcceptEncodingProcessor.process(response, axisOutMsgCtx);
            response.setServiceContext(null);
            response.setOperationContext(axisOutMsgCtx.getOperationContext());
            response.setAxisMessage(axisOutMsgCtx.getAxisOperation().getMessage("Out"));
            response.setServerSide(true);
            response.setProperty("synapse.isresponse", (Object)Boolean.TRUE);
            response.setProperty("TRANSPORT_OUT", axisOutMsgCtx.getProperty("TRANSPORT_OUT"));
            response.setProperty("OutTransportInfo", axisOutMsgCtx.getProperty("OutTransportInfo"));
            response.setTransportIn(axisOutMsgCtx.getTransportIn());
            response.setTransportOut(axisOutMsgCtx.getTransportOut());
            response.setDoingREST(axisOutMsgCtx.isDoingREST());
            if (axisOutMsgCtx.isDoingMTOM()) {
                response.setDoingMTOM(true);
                response.setProperty("enableMTOM", (Object)"true");
            }
            if (axisOutMsgCtx.isDoingSwA()) {
                response.setDoingSwA(true);
                response.setProperty("enableSwA", (Object)"true");
            }
            if (axisOutMsgCtx.getProperty("disableAddressingForOutMessages") != null) {
                response.setProperty("disableAddressingForOutMessages", axisOutMsgCtx.getProperty("disableAddressingForOutMessages"));
            } else {
                response.removeProperty("disableAddressingForOutMessages");
            }
            Object messageType = axisOutMsgCtx.getProperty("messageType");
            if (!"application/x-www-form-urlencoded".equals(messageType)) {
                response.setProperty("messageType", messageType);
            }
            if (axisOutMsgCtx.isSOAP11() != response.isSOAP11()) {
                if (axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP12toSOAP11(response);
                } else {
                    SOAPUtils.convertSOAP11toSOAP12(response);
                }
            }
            if (axisOutMsgCtx.getMessageID() != null) {
                response.setRelationships(new RelatesTo[]{new RelatesTo(axisOutMsgCtx.getMessageID())});
            }
            response.setReplyTo(axisOutMsgCtx.getReplyTo());
            response.setFaultTo(axisOutMsgCtx.getFaultTo());
            if (axisOutMsgCtx.isPropertyTrue("IGNORE_SC_ACCEPTED")) {
                response.setProperty("FORCE_SC_ACCEPTED", (Object)"true");
            }
            Axis2MessageContext synapseInMessageContext = new Axis2MessageContext(response, synapseOutMsgCtx.getConfiguration(), synapseOutMsgCtx.getEnvironment());
            synapseInMessageContext.setResponse(true);
            synapseInMessageContext.setTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
            synapseInMessageContext.setTracingState(synapseOutMsgCtx.getTracingState());
            for (Object key : synapseOutMsgCtx.getPropertyKeySet()) {
                synapseInMessageContext.setProperty((String)key, synapseOutMsgCtx.getProperty((String)key));
            }
            Dispatcher dispatcher = (Dispatcher)synapseOutMsgCtx.getProperty("synape.sal.endpoints.dispatcher");
            if (dispatcher != null && dispatcher.isServerInitiatedSession()) {
                dispatcher.updateSession(synapseInMessageContext);
            }
            StatisticsReporter.reportForAllOnResponseReceived(synapseInMessageContext);
            try {
                synapseOutMsgCtx.getEnvironment().injectMessage(synapseInMessageContext);
            }
            catch (SynapseException syne) {
                Stack<FaultHandler> stack = synapseInMessageContext.getFaultStack();
                if (stack != null && !stack.isEmpty()) {
                    stack.pop().handleFault(synapseInMessageContext, syne);
                }
                log.error((Object)("Synapse encountered an exception, No error handlers found - [Message Dropped]\n" + syne.getMessage()));
            }
        }
    }

    private void removeDuplicateRelatesTo(org.apache.axis2.context.MessageContext mc, RelatesTo[] relates) {
        int insertPos = 0;
        RelatesTo[] newRelates = new RelatesTo[relates.length];
        for (RelatesTo current : relates) {
            boolean found = false;
            for (int j = 0; j < newRelates.length && j < insertPos; ++j) {
                if (!newRelates[j].equals(current) && !newRelates[j].getValue().equals(current.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newRelates[insertPos++] = current;
        }
        RelatesTo[] trimmedRelates = new RelatesTo[insertPos];
        System.arraycopy(newRelates, 0, trimmedRelates, 0, insertPos);
        mc.setRelationships(trimmedRelates);
    }
}

