/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.datasource.DataSourceRepositoryHolder;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseObserver;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.TemplateMediatorFactory;
import org.apache.synapse.config.xml.XMLToTemplateMapper;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;
import org.apache.synapse.config.xml.endpoints.XMLToEndpointMapper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processors.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.rest.API;

public class SynapseConfiguration
implements ManagedLifecycle,
SynapseArtifact {
    private static final Log log = LogFactory.getLog(SynapseConfiguration.class);
    private static final String ENTRY = "entry";
    private static final String ENDPOINT = "endpoint";
    private static final String SEQUENCE = "sequence";
    private static final String TEMPLATE = "sequence-template";
    private Registry registry = null;
    private QName defaultQName = null;
    private Mediator mandatorySequence = null;
    private final Map<String, ProxyService> proxyServices = new ConcurrentHashMap<String, ProxyService>();
    private final Map<String, Startup> startups = new ConcurrentHashMap<String, Startup>();
    private final Map<String, Object> localRegistry = new ConcurrentHashMap<String, Object>();
    private Properties properties = new Properties();
    private Timer synapseTimer;
    private AxisConfiguration axisConfiguration = null;
    private String pathToConfigFile = null;
    private Map<String, SynapseEventSource> eventSources = new ConcurrentHashMap<String, SynapseEventSource>();
    private List<SynapseObserver> observers = new ArrayList<SynapseObserver>();
    private Map<String, PriorityExecutor> executors = new ConcurrentHashMap<String, PriorityExecutor>();
    private Map<String, MessageStore> messageStores = new ConcurrentHashMap<String, MessageStore>();
    private Map<String, MessageProcessor> messageProcessors = new ConcurrentHashMap<String, MessageProcessor>();
    private Map<String, Template> endpointTemplates = new ConcurrentHashMap<String, Template>();
    private Map<String, API> apiTable = new ConcurrentHashMap<String, API>();
    private String description = null;
    private SynapseArtifactDeploymentStore artifactDeploymentStore = new SynapseArtifactDeploymentStore();
    private Map<String, Library> synapseLibraries = new ConcurrentHashMap<String, Library>();
    private Map<String, SynapseImport> synapseImports = new ConcurrentHashMap<String, SynapseImport>();
    private boolean allowHotUpdate = true;
    private boolean initialized = false;

    public synchronized void addSequence(String key, Mediator mediator) {
        this.assertAlreadyExists(key, SEQUENCE);
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceAdded(mediator);
        }
    }

    public synchronized void addSequenceTemplate(String key, TemplateMediator mediator) {
        this.assertAlreadyExists(key, TEMPLATE);
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceTemplateAdded(mediator);
        }
    }

    public synchronized void updateSequenceTemplate(String key, TemplateMediator mediator) {
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceTemplateAdded(mediator);
        }
    }

    public synchronized void updateSequence(String key, Mediator mediator) {
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceAdded(mediator);
        }
    }

    public void addSequence(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        this.localRegistry.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SequenceMediator> getDefinedSequences() {
        HashMap<String, SequenceMediator> definedSequences = new HashMap<String, SequenceMediator>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof SequenceMediator)) continue;
                SequenceMediator seq = (SequenceMediator)o;
                definedSequences.put(seq.getName(), seq);
            }
        }
        return definedSequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TemplateMediator> getSequenceTemplates() {
        HashMap<String, TemplateMediator> definedTemplates = new HashMap<String, TemplateMediator>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof TemplateMediator)) continue;
                TemplateMediator template = (TemplateMediator)o;
                definedTemplates.put(template.getName(), template);
            }
        }
        return definedTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Template> getEndpointTemplates() {
        HashMap<String, Template> definedTemplates = new HashMap<String, Template>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Template)) continue;
                Template template = (Template)o;
                definedTemplates.put(template.getName(), template);
            }
        }
        return definedTemplates;
    }

    public void addAPI(String name, API api) {
        if (!this.apiTable.containsKey(name)) {
            for (API existingAPI : this.apiTable.values()) {
                if (!api.getVersion().equals(existingAPI.getVersion()) || !existingAPI.getContext().equals(api.getContext())) continue;
                this.handleException("URL context: " + api.getContext() + " is already registered" + " with the API: " + existingAPI.getName());
            }
            this.apiTable.put(name, api);
        } else {
            this.handleException("Duplicate resource definition by the name: " + name);
        }
    }

    public void updateAPI(String name, API api) {
        if (!this.apiTable.containsKey(name)) {
            this.handleException("No API exists by the name: " + name);
        } else {
            for (API existingAPI : this.apiTable.values()) {
                if (!api.getVersion().equals(existingAPI.getVersion()) || !existingAPI.getContext().equals(api.getContext()) || name.equals(api.getName())) continue;
                this.handleException("URL context: " + api.getContext() + " is already registered" + " with the API: " + existingAPI.getName());
            }
            this.apiTable.put(name, api);
        }
    }

    public Collection<API> getAPIs() {
        return Collections.unmodifiableCollection(this.apiTable.values());
    }

    public API getAPI(String name) {
        return this.apiTable.get(name);
    }

    public void removeAPI(String name) {
        API api = this.apiTable.get(name);
        if (api != null) {
            this.apiTable.remove(name);
        } else {
            this.handleException("No API exists by the name: " + name);
        }
    }

    public TemplateMediator getSequenceTemplate(String key) {
        TemplateMediator templateFromLib;
        Object o = this.getEntry(key);
        if (o instanceof TemplateMediator) {
            return (TemplateMediator)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(new XMLToTemplateMapper());
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                TemplateMediator m;
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof TemplateMediator) {
                    this.localRegistry.put(key, entry);
                    return (TemplateMediator)o;
                }
                if (o instanceof OMNode && (m = (TemplateMediator)new TemplateMediatorFactory().createMediator((OMElement)o, this.properties)) != null) {
                    entry.setValue(m);
                    return m;
                }
            }
        } else {
            Object object;
            Object value = entry.getValue();
            if (value instanceof OMNode && (object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties())) instanceof TemplateMediator) {
                entry.setValue(object);
                return (TemplateMediator)object;
            }
        }
        if ((templateFromLib = LibDeployerUtils.getLibArtifact(this.synapseLibraries, key, TemplateMediator.class)) != null) {
            return templateFromLib;
        }
        return null;
    }

    public Mediator getMandatorySequence() {
        return this.mandatorySequence;
    }

    public void setMandatorySequence(Mediator mandatorySequence) {
        this.mandatorySequence = mandatorySequence;
    }

    public Mediator getSequence(String key) {
        Object o = this.getEntry(key);
        if (o instanceof Mediator) {
            return (Mediator)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(MediatorFactoryFinder.getInstance());
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                Mediator m;
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof Mediator) {
                    this.localRegistry.put(key, entry);
                    return (Mediator)o;
                }
                if (o instanceof OMNode && (m = (Mediator)MediatorFactoryFinder.getInstance().getObjectFromOMNode((OMNode)o, this.properties)) != null) {
                    entry.setValue(m);
                    return m;
                }
            }
        } else {
            Object object;
            Object value = entry.getValue();
            if (value instanceof OMNode && (object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties())) instanceof Mediator) {
                entry.setValue(object);
                return (Mediator)object;
            }
        }
        return null;
    }

    public synchronized void removeSequence(String key) {
        Object sequence = this.localRegistry.get(key);
        if (sequence instanceof Mediator) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.sequenceRemoved((Mediator)sequence);
            }
        } else {
            this.handleException("No sequence exists by the key/name : " + key);
        }
    }

    public synchronized void removeSequenceTemplate(String name) {
        Object sequence = this.localRegistry.get(name);
        if (sequence instanceof TemplateMediator) {
            this.localRegistry.remove(name);
            for (SynapseObserver o : this.observers) {
                o.sequenceTemplateRemoved((Mediator)sequence);
            }
        } else {
            this.handleException("No template exists by the key/name : " + name);
        }
    }

    public Mediator getMainSequence() {
        return this.getSequence("main");
    }

    public Mediator getFaultSequence() {
        return this.getSequence("fault");
    }

    public synchronized void addEntry(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        if (entry.getType() == 2 && entry.getValue() == null) {
            try {
                SynapseEnvironment synEnv = SynapseConfigUtils.getSynapseEnvironment(this.axisConfiguration);
                entry.setValue(SynapseConfigUtils.getOMElementFromURL(entry.getSrc().toString(), synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getSynapseHome() : ""));
                this.localRegistry.put(key, entry);
                for (SynapseObserver o : this.observers) {
                    o.entryAdded(entry);
                }
            }
            catch (IOException e) {
                this.handleException("Can not read from source URL : " + entry.getSrc());
            }
        } else {
            this.localRegistry.put(key, entry);
            for (SynapseObserver o : this.observers) {
                o.entryAdded(entry);
            }
        }
    }

    public synchronized void updateEntry(String key, Entry entry) {
        if (entry.getType() == 2 && entry.getValue() == null) {
            try {
                SynapseEnvironment synEnv = SynapseConfigUtils.getSynapseEnvironment(this.axisConfiguration);
                entry.setValue(SynapseConfigUtils.getOMElementFromURL(entry.getSrc().toString(), synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getSynapseHome() : ""));
                this.localRegistry.put(key, entry);
                for (SynapseObserver o : this.observers) {
                    o.entryAdded(entry);
                }
            }
            catch (IOException e) {
                this.handleException("Can not read from source URL : " + entry.getSrc());
            }
        } else {
            this.localRegistry.put(key, entry);
            for (SynapseObserver o : this.observers) {
                o.entryAdded(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Entry> getCachedEntries() {
        HashMap<String, Entry> cachedEntries = new HashMap<String, Entry>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                Entry entry;
                if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
                cachedEntries.put(entry.getKey(), entry);
            }
        }
        return cachedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Entry> getDefinedEntries() {
        HashMap<String, Entry> definedEntries = new HashMap<String, Entry>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Entry) || ((Entry)o).getType() == 3) continue;
                Entry entry = (Entry)o;
                definedEntries.put(entry.getKey(), entry);
            }
        }
        return definedEntries;
    }

    public Object getLocalRegistryEntry(String key) {
        Entry entry;
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof Entry && !(entry = (Entry)o).isDynamic()) {
            return entry.getValue();
        }
        return null;
    }

    public Object getEntry(String key) {
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof Entry) {
            Entry entry = (Entry)o;
            if (!entry.isDynamic() || entry.isCached() && !entry.isExpired()) {
                return entry.getValue();
            }
            if (this.registry != null) {
                if (entry.isCached()) {
                    try {
                        o = this.registry.getResource(entry, this.getProperties());
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error while loading the resource " + key + " from the remote " + "registry. Previously cached value will be used. Check the " + "registry accessibility."));
                        return entry.getValue();
                    }
                } else {
                    o = this.registry.getResource(entry, this.getProperties());
                }
            } else {
                if (entry.isCached()) {
                    log.warn((Object)("The registry is no longer available in the Synapse configuration. Using the previously cached value for the resource : " + key));
                    return entry.getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will not  evaluate the value of the remote entry with a key " + key + ",  because the registry is not available"));
                }
                return null;
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntryDefinition(String key) {
        Object o = this.localRegistry.get(key);
        if (o == null || o instanceof Entry) {
            if (o == null) {
                SynapseConfiguration synapseConfiguration = this;
                synchronized (synapseConfiguration) {
                    o = this.localRegistry.get(key);
                    if (o == null) {
                        Entry entry = new Entry(key);
                        entry.setType(3);
                        this.addEntry(key, entry);
                        return entry;
                    }
                }
            }
            return (Entry)o;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is no local registry entry for key : " + key));
        }
        return null;
    }

    public synchronized void removeEntry(String key) {
        Object entry = this.localRegistry.get(key);
        if (entry instanceof Entry) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.entryRemoved((Entry)entry);
            }
        } else {
            this.handleException("No entry exists by the key : " + key);
        }
    }

    public void clearCachedEntry(String key) {
        Entry entry = this.getEntryDefinition(key);
        if (entry != null && entry.isDynamic() && entry.isCached()) {
            entry.clearCache();
        }
    }

    public synchronized void clearCache() {
        for (Object o : this.localRegistry.values()) {
            Entry entry;
            if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
            entry.clearCache();
        }
    }

    public synchronized void addEndpoint(String key, Endpoint endpoint) {
        this.assertAlreadyExists(key, ENDPOINT);
        this.localRegistry.put(key, endpoint);
        for (SynapseObserver o : this.observers) {
            o.endpointAdded(endpoint);
        }
    }

    public synchronized void updateEndpoint(String key, Endpoint endpoint) {
        this.localRegistry.put(key, endpoint);
        for (SynapseObserver o : this.observers) {
            o.endpointAdded(endpoint);
        }
    }

    public void addEndpoint(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        this.localRegistry.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Endpoint> getDefinedEndpoints() {
        HashMap<String, Endpoint> definedEndpoints = new HashMap<String, Endpoint>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Endpoint)) continue;
                Endpoint ep = (Endpoint)o;
                definedEndpoints.put(ep.getName(), ep);
            }
        }
        return definedEndpoints;
    }

    public Endpoint getEndpoint(String key) {
        Object o = this.getEntry(key);
        if (o != null && o instanceof Endpoint) {
            return (Endpoint)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(XMLToEndpointMapper.getInstance());
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                Endpoint e;
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof Endpoint) {
                    this.localRegistry.put(key, entry);
                    return (Endpoint)o;
                }
                if (o instanceof OMNode && (e = (Endpoint)XMLToEndpointMapper.getInstance().getObjectFromOMNode((OMNode)o, this.properties)) != null) {
                    entry.setValue(e);
                    return e;
                }
            }
        } else {
            Object object;
            Object value = entry.getValue();
            if (value instanceof OMNode && (object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties())) instanceof Endpoint) {
                entry.setValue(object);
                return (Endpoint)object;
            }
        }
        return null;
    }

    public synchronized void removeEndpoint(String key) {
        Object endpoint = this.localRegistry.get(key);
        if (endpoint instanceof Endpoint) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.endpointRemoved((Endpoint)endpoint);
            }
        } else {
            this.handleException("No endpoint exists by the key/name : " + key);
        }
    }

    public synchronized void addProxyService(String name, ProxyService proxy) {
        if (!this.proxyServices.containsKey(name)) {
            this.proxyServices.put(name, proxy);
            for (SynapseObserver o : this.observers) {
                o.proxyServiceAdded(proxy);
            }
        } else {
            this.handleException("Duplicate proxy service by the name : " + name);
        }
    }

    public ProxyService getProxyService(String name) {
        return this.proxyServices.get(name);
    }

    public synchronized void removeProxyService(String name) {
        ProxyService proxy = this.proxyServices.get(name);
        if (proxy == null) {
            this.handleException("Unknown proxy service for name : " + name);
        } else {
            try {
                if (this.getAxisConfiguration().getServiceForActivation(name) != null) {
                    if (this.getAxisConfiguration().getServiceForActivation(name).isActive()) {
                        this.getAxisConfiguration().getService(name).setActive(false);
                    }
                    this.getAxisConfiguration().removeService(name);
                }
                this.proxyServices.remove(name);
                for (SynapseObserver o : this.observers) {
                    o.proxyServiceRemoved(proxy);
                }
            }
            catch (AxisFault axisFault) {
                this.handleException(axisFault.getMessage());
            }
        }
    }

    public Collection<ProxyService> getProxyServices() {
        return Collections.unmodifiableCollection(this.proxyServices.values());
    }

    public Map getLocalRegistry() {
        return Collections.unmodifiableMap(this.localRegistry);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setAxisConfiguration(AxisConfiguration axisConfig) {
        this.axisConfiguration = axisConfig;
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    public String getPathToConfigFile() {
        return this.pathToConfigFile;
    }

    public void setPathToConfigFile(String pathToConfigFile) {
        this.pathToConfigFile = pathToConfigFile;
    }

    public void setDefaultQName(QName defaultQName) {
        this.defaultQName = defaultQName;
    }

    public QName getDefaultQName() {
        return this.defaultQName;
    }

    public Timer getSynapseTimer() {
        if (this.synapseTimer == null) {
            this.handleException("Attempted to access the Synapse timer before initializing SynapseConfiguration");
        }
        return this.synapseTimer;
    }

    public Collection<Startup> getStartups() {
        return this.startups.values();
    }

    public Startup getStartup(String id) {
        return this.startups.get(id);
    }

    public synchronized void addStartup(Startup startup) {
        if (!this.startups.containsKey(startup.getName())) {
            this.startups.put(startup.getName(), startup);
            for (SynapseObserver o : this.observers) {
                o.startupAdded(startup);
            }
        } else {
            this.handleException("Duplicate startup by the name : " + startup.getName());
        }
    }

    public synchronized void updateStartup(Startup startup) {
        this.startups.put(startup.getName(), startup);
        for (SynapseObserver o : this.observers) {
            o.startupAdded(startup);
        }
    }

    public synchronized void removeStartup(String name) {
        Startup startup = this.startups.get(name);
        if (startup != null) {
            this.startups.remove(name);
            for (SynapseObserver o : this.observers) {
                o.startupRemoved(startup);
            }
        } else {
            this.handleException("No startup exists by the name : " + name);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String propKey, String def) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return def;
    }

    public long getProperty(String propKey, long def) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return Long.valueOf(val);
        }
        return def;
    }

    public String getProperty(String propKey) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init(SynapseEnvironment se) {
        if (this.initialized) {
            log.warn((Object)"Attempted to re-initialize SynapseConfiguration");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the Synapse Configuration using the SynapseEnvironment");
        }
        try {
            this.doInit(se);
        }
        finally {
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        if (!this.initialized) {
            log.warn((Object)"Attempted to destroy uninitialized SynapseConfiguration");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying the Synapse Configuration");
        }
        try {
            this.doDestroy();
        }
        finally {
            this.initialized = false;
        }
    }

    private void doInit(SynapseEnvironment se) {
        this.synapseTimer = new Timer(true);
        if (this.registry != null && this.registry instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.registry)).init(se);
        }
        for (Endpoint endpoint : this.getDefinedEndpoints().values()) {
            endpoint.init(se);
        }
        for (TemplateMediator templateMediator : this.getSequenceTemplates().values()) {
            templateMediator.init(se);
        }
        for (ManagedLifecycle managedLifecycle : this.getDefinedSequences().values()) {
            if (managedLifecycle == null) continue;
            managedLifecycle.init(se);
        }
        for (ProxyService proxyService : this.getProxyServices()) {
            if (proxyService.getTargetInLineEndpoint() != null) {
                proxyService.getTargetInLineEndpoint().init(se);
            }
            if (proxyService.getTargetInLineInSequence() != null) {
                proxyService.getTargetInLineInSequence().init(se);
            }
            if (proxyService.getTargetInLineOutSequence() != null) {
                proxyService.getTargetInLineOutSequence().init(se);
            }
            if (proxyService.getTargetInLineFaultSequence() == null) continue;
            proxyService.getTargetInLineFaultSequence().init(se);
        }
        for (ManagedLifecycle managedLifecycle : this.getStartups()) {
            if (managedLifecycle == null) continue;
            managedLifecycle.init(se);
        }
        for (PriorityExecutor priorityExecutor : this.getPriorityExecutors().values()) {
            priorityExecutor.init();
        }
        for (MessageStore messageStore : this.messageStores.values()) {
            messageStore.init(se);
        }
        for (MessageProcessor messageProcessor : this.messageProcessors.values()) {
            messageProcessor.init(se);
        }
        for (API aPI : this.apiTable.values()) {
            aPI.init(se);
        }
    }

    private void doDestroy() {
        this.synapseTimer.cancel();
        this.synapseTimer = null;
        for (ProxyService proxyService : this.getProxyServices()) {
            if (proxyService.getTargetInLineInSequence() != null) {
                proxyService.getTargetInLineInSequence().destroy();
            }
            if (proxyService.getTargetInLineOutSequence() == null) continue;
            proxyService.getTargetInLineOutSequence().destroy();
        }
        for (ManagedLifecycle managedLifecycle : this.getDefinedSequences().values()) {
            managedLifecycle.destroy();
        }
        for (TemplateMediator templateMediator : this.getSequenceTemplates().values()) {
            templateMediator.destroy();
        }
        for (Endpoint endpoint : this.getDefinedEndpoints().values()) {
            endpoint.destroy();
        }
        for (ManagedLifecycle managedLifecycle : this.startups.values()) {
            managedLifecycle.destroy();
        }
        try {
            SALSessions.getInstance().reset();
            DataSourceRepositoryHolder.getInstance().getDataSourceRepositoryManager().clear();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        for (PriorityExecutor priorityExecutor : this.executors.values()) {
            priorityExecutor.destroy();
        }
        for (MessageStore messageStore : this.messageStores.values()) {
            messageStore.destroy();
        }
        for (MessageProcessor messageProcessor : this.messageProcessors.values()) {
            messageProcessor.destroy();
        }
        for (API aPI : this.apiTable.values()) {
            aPI.destroy();
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public synchronized void addEventSource(String name, SynapseEventSource eventSource) {
        if (!this.eventSources.containsKey(name)) {
            this.eventSources.put(name, eventSource);
            for (SynapseObserver o : this.observers) {
                o.eventSourceAdded(eventSource);
            }
        } else {
            this.handleException("Duplicate event source by the name : " + name);
        }
    }

    public SynapseEventSource getEventSource(String name) {
        return this.eventSources.get(name);
    }

    public synchronized void removeEventSource(String name) {
        SynapseEventSource eventSource = this.eventSources.get(name);
        if (eventSource == null) {
            this.handleException("No event source exists by the name : " + name);
        } else {
            try {
                if (this.getAxisConfiguration().getServiceForActivation(name) != null) {
                    if (this.getAxisConfiguration().getServiceForActivation(name).isActive()) {
                        this.getAxisConfiguration().getService(name).setActive(false);
                    }
                    this.getAxisConfiguration().removeService(name);
                }
                this.eventSources.remove(name);
                for (SynapseObserver o : this.observers) {
                    o.eventSourceRemoved(eventSource);
                }
            }
            catch (AxisFault axisFault) {
                this.handleException(axisFault.getMessage());
            }
        }
    }

    public Collection<SynapseEventSource> getEventSources() {
        return this.eventSources.values();
    }

    public void setEventSources(Map<String, SynapseEventSource> eventSources) {
        this.eventSources = eventSources;
    }

    public void registerObserver(SynapseObserver o) {
        if (!this.observers.contains(o)) {
            this.observers.add(o);
        }
    }

    public List<SynapseObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    public synchronized void addPriorityExecutor(String name, PriorityExecutor executor) {
        if (!this.executors.containsKey(name)) {
            this.executors.put(name, executor);
            for (SynapseObserver o : this.observers) {
                o.priorityExecutorAdded(executor);
            }
        } else {
            this.handleException("Duplicate priority executor by the name: " + name);
        }
    }

    public synchronized void updatePriorityExecutor(String name, PriorityExecutor executor) {
        this.executors.put(name, executor);
        for (SynapseObserver o : this.observers) {
            o.priorityExecutorAdded(executor);
        }
    }

    public Map<String, PriorityExecutor> getPriorityExecutors() {
        return this.executors;
    }

    public synchronized PriorityExecutor removeExecutor(String name) {
        PriorityExecutor executor = this.executors.remove(name);
        if (executor != null) {
            for (SynapseObserver o : this.observers) {
                o.priorityExecutorRemoved(executor);
            }
        }
        return executor;
    }

    public MessageStore getMessageStore(String name) {
        return this.messageStores.get(name);
    }

    public void addMessageStore(String name, MessageStore messageStore) {
        if (!this.messageStores.containsKey(name)) {
            this.messageStores.put(name, messageStore);
        } else {
            this.handleException("Duplicate message store : " + name);
        }
    }

    public Map<String, MessageStore> getMessageStores() {
        return this.messageStores;
    }

    public MessageStore removeMessageStore(String name) {
        return this.messageStores.remove(name);
    }

    public void addMessageProcessor(String name, MessageProcessor processor) {
        if (!this.messageProcessors.containsKey(name)) {
            this.messageProcessors.put(name, processor);
        } else {
            this.handleException("Duplicate Message Processor " + name);
        }
    }

    public Map<String, MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public MessageProcessor removeMessageProcessor(String name) {
        return this.messageProcessors.remove(name);
    }

    public void addSynapseLibrary(String name, Library library) {
        if (!this.synapseLibraries.containsKey(name)) {
            this.synapseLibraries.put(name, library);
        } else {
            this.handleException("Duplicate Synapse Library " + name);
        }
    }

    public Map<String, Library> getSynapseLibraries() {
        return this.synapseLibraries;
    }

    public Library removeSynapseLibrary(String name) {
        return this.synapseLibraries.remove(name);
    }

    public void addSynapseImport(String name, SynapseImport synImport) {
        if (!this.synapseImports.containsKey(name)) {
            this.synapseImports.put(name, synImport);
        } else {
            this.handleException("Duplicate Synapse Library " + name);
        }
    }

    public Map<String, SynapseImport> getSynapseImports() {
        return this.synapseImports;
    }

    public SynapseImport removeSynapseImport(String name) {
        return this.synapseImports.remove(name);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public SynapseArtifactDeploymentStore getArtifactDeploymentStore() {
        return this.artifactDeploymentStore;
    }

    private void assertAlreadyExists(String key, String type) {
        if (key == null || "".equals(key)) {
            this.handleException("Given entry key is empty or null.");
        }
        if (this.localRegistry.containsKey(key.trim())) {
            this.handleException("Duplicate " + type + " definition for key : " + key);
        }
    }

    private void assertEntryNull(Entry entry, String key) {
        if (entry == null) {
            this.handleException("Cannot locate an either local or remote entry for key : " + key);
        }
    }

    public void addEndpointTemplate(String name, Template template) {
        this.assertAlreadyExists(name, "template");
        this.localRegistry.put(name, template);
    }

    public void updateEndpointTemplate(String name, Template template) {
        this.localRegistry.put(name, template);
    }

    public void removeEndpointTemplate(String name) {
        Object sequence = this.localRegistry.get(name);
        if (sequence instanceof Template) {
            this.localRegistry.remove(name);
        } else {
            this.handleException("No template exists by the key/name : " + name);
        }
    }

    public Template getEndpointTemplate(String key) {
        Template templateFromLib;
        Object o = this.getEntry(key);
        if (o instanceof Template) {
            return (Template)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(new XMLToTemplateMapper());
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                Template m;
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof Template) {
                    this.localRegistry.put(key, entry);
                    return (Template)o;
                }
                if (o instanceof OMNode && (m = new TemplateFactory().createEndpointTemplate((OMElement)o, this.properties)) != null) {
                    entry.setValue(m);
                    return m;
                }
            }
        } else {
            Object object;
            Object value = entry.getValue();
            if (value instanceof OMNode && (object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties())) instanceof Template) {
                entry.setValue(object);
                return (Template)object;
            }
        }
        if ((templateFromLib = LibDeployerUtils.getLibArtifact(this.synapseLibraries, key, Template.class)) != null) {
            return templateFromLib;
        }
        return null;
    }

    public boolean isAllowHotUpdate() {
        return this.allowHotUpdate;
    }

    public void setAllowHotUpdate(boolean allowHotUpdate) {
        this.allowHotUpdate = allowHotUpdate;
    }
}

