/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.synapse.transport.passthru.util.ControlledByteBuffer;

public class BufferFactory {
    private volatile ControlledByteBuffer[] buffers;
    private volatile int marker = -1;
    private ByteBufferAllocator allocator = null;
    private Lock lock = new ReentrantLock();
    private int bufferSize = 8192;

    public BufferFactory(int bufferSize, ByteBufferAllocator allocator, int size) {
        this.bufferSize = bufferSize;
        this.allocator = allocator != null ? allocator : HeapByteBufferAllocator.INSTANCE;
        this.buffers = new ControlledByteBuffer[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlledByteBuffer getBuffer() {
        if (this.marker == -1) {
            return new ControlledByteBuffer(this.allocator.allocate(this.bufferSize));
        }
        try {
            this.lock.lock();
            if (this.marker >= 0) {
                ControlledByteBuffer controlledByteBuffer = this.buffers[this.marker];
                controlledByteBuffer.clear();
                controlledByteBuffer.forceSetInputMode();
                this.buffers[this.marker] = null;
                --this.marker;
                ControlledByteBuffer controlledByteBuffer2 = controlledByteBuffer;
                return controlledByteBuffer2;
            }
        }
        finally {
            this.lock.unlock();
        }
        return new ControlledByteBuffer(this.allocator.allocate(this.bufferSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ControlledByteBuffer buffer) {
        try {
            this.lock.lock();
            if (this.marker < this.buffers.length - 1) {
                buffer.clear();
                buffer.forceSetInputMode();
                this.buffers[++this.marker] = buffer;
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

