/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.connections;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.synapse.transport.passthru.ConnectCallback;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.HostConnections;

public class TargetConnections {
    private static final Log log = LogFactory.getLog(TargetConnections.class);
    private final Map<String, HostConnections> poolMap = new ConcurrentHashMap<String, HostConnections>();
    private int maxConnections;
    private ConnectingIOReactor ioReactor;
    private ConnectCallback callback = null;

    public TargetConnections(ConnectingIOReactor ioReactor, TargetConfiguration targetConfiguration, ConnectCallback callback) {
        this.maxConnections = targetConfiguration.getMaxConnections();
        this.ioReactor = ioReactor;
        this.callback = callback;
    }

    public NHttpClientConnection getConnection(String host, int port) {
        HostConnections pool;
        NHttpClientConnection connection;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get a connection to the " + host + ":" + port));
        }
        if ((connection = (pool = this.getConnectionPool(host, port)).getConnection()) == null) {
            if (pool.canHaveMoreConnections()) {
                this.ioReactor.connect((SocketAddress)new InetSocketAddress(host, port), null, (Object)pool, (SessionRequestCallback)this.callback);
            } else {
                log.warn((Object)("Connection pool reached maximum allowed connections for: " + host + ":" + port + ". Target server may have become slow"));
            }
        }
        return connection;
    }

    public NHttpClientConnection getExistingConnection(String host, int port) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get an existing connection to the " + host + ":" + port));
        }
        HostConnections pool = this.getConnectionPool(host, port);
        return pool.getConnection();
    }

    public void closeConnection(NHttpClientConnection conn) {
        HostConnections pool = (HostConnections)conn.getContext().getAttribute("CONNECTION_POOL");
        TargetContext.get((NHttpConnection)conn).reset();
        if (pool != null) {
            pool.forget(conn);
        } else {
            log.fatal((Object)"Connection without a pool. Something wrong. Need to fix.");
        }
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutdownConnection(NHttpClientConnection conn) {
        this.shutdownConnection(conn, false);
    }

    public void shutdownConnection(NHttpClientConnection conn, boolean isError) {
        HostConnections pool = (HostConnections)conn.getContext().getAttribute("CONNECTION_POOL");
        TargetContext.get((NHttpConnection)conn).reset(isError);
        if (pool != null) {
            pool.forget(conn);
        } else {
            log.fatal((Object)"Connection without a pool. Something wrong. Need to fix.");
        }
        try {
            conn.shutdown();
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    public void releaseConnection(NHttpClientConnection conn) {
        HostConnections pool = (HostConnections)conn.getContext().getAttribute("CONNECTION_POOL");
        TargetContext.get((NHttpConnection)conn).reset();
        if (pool != null) {
            pool.release(conn);
        } else {
            log.fatal((Object)"Connection without a pool. Something wrong. Need to fix.");
        }
    }

    public void addConnection(NHttpClientConnection conn) {
        HostConnections pool = (HostConnections)conn.getContext().getAttribute("CONNECTION_POOL");
        if (pool != null) {
            pool.addConnection(conn);
        } else {
            log.fatal((Object)"Connection without a pool. Something wrong. Need to fix.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostConnections getConnectionPool(String host, int port) {
        String key = host + ":" + port;
        if (!this.poolMap.containsKey(key)) {
            Map<String, HostConnections> map = this.poolMap;
            synchronized (map) {
                if (!this.poolMap.containsKey(key)) {
                    HostConnections pool = new HostConnections(host, port, this.maxConnections);
                    this.poolMap.put(key, pool);
                }
            }
        }
        return this.poolMap.get(key);
    }
}

