/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.OutputStream;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.TargetErrorHandler;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.TargetConnections;
import org.apache.synapse.transport.passthru.util.TargetRequestFactory;

public class DeliveryAgent {
    private static final Log log = LogFactory.getLog(DeliveryAgent.class);
    private Map<String, Queue<MessageContext>> waitingMessages = new ConcurrentHashMap<String, Queue<MessageContext>>();
    private TargetConnections targetConnections;
    private TargetConfiguration targetConfiguration;
    private TargetErrorHandler targetErrorHandler;
    private Lock lock = new ReentrantLock();

    public DeliveryAgent(TargetConfiguration targetConfiguration, TargetConnections targetConnections) {
        this.targetConfiguration = targetConfiguration;
        this.targetConnections = targetConnections;
        this.targetErrorHandler = new TargetErrorHandler(targetConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(MessageContext msgContext, String host, int port) throws AxisFault {
        String key = host + ":" + port;
        Queue<MessageContext> queue = null;
        this.lock.lock();
        try {
            queue = this.waitingMessages.get(key);
            if (queue == null) {
                queue = new ConcurrentLinkedQueue<MessageContext>();
                this.waitingMessages.put(key, queue);
            }
            if (queue.size() == Integer.MAX_VALUE) {
                MessageContext msgCtx = queue.poll();
                this.targetErrorHandler.handleError(msgCtx, 101504, "Error connecting to the back end", null, ProtocolState.REQUEST_READY);
            }
            queue.add(msgContext);
        }
        finally {
            this.lock.unlock();
        }
        NHttpClientConnection conn = this.targetConnections.getConnection(host, port);
        if (conn != null) {
            conn.resetInput();
            conn.resetOutput();
            MessageContext messageContext = queue.poll();
            if (messageContext != null) {
                this.tryNextMessage(messageContext, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorConnecting(String host, int port, int errorCode, String message) {
        String key = host + ":" + port;
        Queue<MessageContext> queue = this.waitingMessages.get(key);
        if (queue != null) {
            MessageContext msgCtx = queue.poll();
            if (msgCtx != null) {
                String errorMessage = "Error while connecting to the endpoint";
                if (message != null) {
                    errorMessage = errorMessage + " (" + message + ")";
                }
                this.targetErrorHandler.handleError(msgCtx, errorCode, errorMessage, null, ProtocolState.REQUEST_READY);
                MessageContext messageContext = msgCtx;
                synchronized (messageContext) {
                    msgCtx.setProperty("WAIT_BUILDER_IN_STREAM_COMPLETE", (Object)Boolean.TRUE);
                    msgCtx.notifyAll();
                }
            }
        } else {
            throw new IllegalStateException("Queue cannot be null for: " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(String host, int port, NHttpClientConnection conn) {
        Queue<MessageContext> queue = null;
        this.lock.lock();
        try {
            queue = this.waitingMessages.get(host + ":" + port);
        }
        finally {
            this.lock.unlock();
        }
        while (queue.size() > 0) {
            if (conn == null) {
                conn = this.targetConnections.getExistingConnection(host, port);
            }
            if (conn == null) break;
            MessageContext messageContext = queue.poll();
            if (messageContext != null) {
                this.tryNextMessage(messageContext, conn);
            }
            conn = null;
        }
    }

    private void tryNextMessage(MessageContext messageContext, NHttpClientConnection conn) {
        if (conn != null) {
            try {
                TargetContext.get((NHttpConnection)conn).setRequestMsgCtx(messageContext);
                this.submitRequest(conn, messageContext);
            }
            catch (AxisFault e) {
                log.error((Object)"IO error while sending the request out", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRequest(NHttpClientConnection conn, MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting new request to the connection: " + conn));
        }
        TargetRequest request = TargetRequestFactory.create(msgContext, this.targetConfiguration);
        TargetContext.setRequest((NHttpConnection)conn, request);
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (pipe != null) {
            pipe.attachConsumer((IOControl)conn);
            request.connect(pipe);
            if (Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked"))) {
                MessageContext messageContext = msgContext;
                synchronized (messageContext) {
                    OutputStream out = pipe.getOutputStream();
                    msgContext.setProperty("BUILDER_OUTPUT_STREAM", (Object)out);
                    msgContext.setProperty("WAIT_BUILDER_IN_STREAM_COMPLETE", (Object)Boolean.TRUE);
                    msgContext.notifyAll();
                }
                return;
            }
        }
        conn.requestOutput();
    }
}

