/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.connectionfactory;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportUtils;

public class AMQPTransportConnectionFactory {
    private String name = null;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Connection connection = null;
    private Channel channel = null;

    public AMQPTransportConnectionFactory(Map<String, String> parameters, ExecutorService es) throws AMQPTransportException {
        try {
            this.connection = this.createConnection(es, parameters);
            this.channel = this.createChannel(this.connection, parameters);
        }
        catch (Exception e) {
            String msg = "Could not initialize the connection factory with parameters\n";
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                msg = msg + entry.getKey() + ":" + entry.getValue() + "\n";
            }
            throw new AMQPTransportException(msg, e);
        }
    }

    public AMQPTransportConnectionFactory(Parameter parameter, ExecutorService es) throws AMQPTransportException {
        try {
            this.name = parameter.getName();
            ParameterIncludeImpl pi = new ParameterIncludeImpl();
            if (!(parameter.getValue() instanceof OMElement)) {
                throw new AMQPTransportException("The connection factory '" + parameter.getName() + "' is invalid. It's required to have the least connection factory definition with '" + "transport.amqp.Uri" + "' parameter. Example: \n" + "\n<transportReceiver name=\"amqp\" class=\"org.wso2.carbon.transports.amqp.AMQPTransportListener\">\n" + "   <parameter name=\"default\" locked=\"false\">\n" + "      <parameter name=\"transport.amqp.Uri\" locked=\"false\">amqp://rajika:rajika123@localhost:5672/default</parameter>\n" + "   </parameter>\n" + "</transportReceiver>\n");
            }
            try {
                pi.deserializeParameters(parameter.getParameterElement());
            }
            catch (AxisFault axisFault) {
                throw new AMQPTransportException("Error reading connection factory configuration from '" + parameter.getName() + "'", axisFault);
            }
            for (Parameter entry : pi.getParameters()) {
                this.parameters.put(entry.getName(), (String)entry.getValue());
            }
            this.connection = this.createConnection(es, this.parameters);
            this.channel = this.createChannel(this.connection, this.parameters);
        }
        catch (Exception e) {
            throw new AMQPTransportException("Could not initialize the connection factory '" + parameter.getName() + "'", e);
        }
    }

    public void shutDownConnection() throws IOException {
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
    }

    public void shutDownChannel() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getName() {
        return this.name;
    }

    public String getParameterValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private Connection createConnection(ExecutorService es, Map<String, String> parameters) throws IOException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setUri(parameters.get("transport.amqp.Uri"));
        if (parameters.get("transport.amqp.BrokerList") != null) {
            Address[] addresses = AMQPTransportUtils.getAddressArray(parameters.get("transport.amqp.BrokerList"), ",", ':');
            return connectionFactory.newConnection(es, addresses);
        }
        return connectionFactory.newConnection(es);
    }

    private Channel createChannel(Connection connection, Map<String, String> parameters) throws IOException {
        Channel ch;
        if (parameters.get("transport.amqp.ChannelNumber") != null) {
            int index = 0;
            try {
                index = Integer.parseInt(parameters.get("transport.amqp.ChannelNumber"));
            }
            catch (NumberFormatException e) {
                index = 1;
            }
            ch = connection.createChannel(index);
        } else {
            ch = connection.createChannel();
        }
        int prefetchSize = 1024;
        if (parameters.get("transport.amqp.ChannelPreFetchSize") != null) {
            try {
                prefetchSize = Integer.parseInt(parameters.get("transport.amqp.ChannelPreFetchSize"));
            }
            catch (NumberFormatException e) {
                prefetchSize = 1024;
            }
        }
        int prefetchCount = 0;
        if (parameters.get("transport.amqp.ChannelPreFetchCountSize") != null) {
            try {
                prefetchCount = Integer.parseInt(parameters.get("transport.amqp.ChannelPreFetchCountSize"));
                ch.basicQos(prefetchCount);
            }
            catch (NumberFormatException e) {
                prefetchCount = 0;
            }
        }
        boolean useGlobally = false;
        if (parameters.get("transport.amqp.IsQoSGlobally") != null) {
            useGlobally = Boolean.parseBoolean(parameters.get("transport.amqp.IsQoSGlobally"));
        }
        return ch;
    }
}

