/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.keystore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.IKeyStoreLoader;
import org.apache.synapse.securevault.SecureVaultException;

public abstract class AbstractKeyStoreLoader
implements IKeyStoreLoader {
    protected Log log = LogFactory.getLog(this.getClass());

    protected AbstractKeyStoreLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore getKeyStore(String location, String storePassword, String storeType, String provider) {
        File keyStoreFile = new File(location);
        if (!keyStoreFile.exists()) {
            this.handleException("KeyStore can not be found at ' " + keyStoreFile + " '");
        }
        BufferedInputStream bis = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading KeyStore from : " + location + " Store-Type : " + storeType + " Provider : " + provider));
            }
            bis = new BufferedInputStream(new FileInputStream(keyStoreFile));
            KeyStore keyStore = provider != null ? KeyStore.getInstance(storeType, provider) : KeyStore.getInstance(storeType);
            keyStore.load(bis, storePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException e) {
            this.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (IOException e) {
            this.handleException("IOError loading keyStore from ' " + location + " ' ", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (CertificateException e) {
            this.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (NoSuchProviderException e) {
            this.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    protected void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new SecureVaultException(msg, e);
    }

    protected void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SecureVaultException(msg);
    }
}

