/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.nhttp.AccessHandler;
import org.apache.synapse.transport.nhttp.LoggingIOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingNHttpServerConnection
extends DefaultNHttpServerConnection {
    private static final AtomicLong COUNT = new AtomicLong();
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Log iolog;
    private final Log headerlog;
    private final Log accesslog;
    private final Log wirelog;
    private final String id;

    public LoggingNHttpServerConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, requestFactory, allocator, params);
        this.iolog = LogFactory.getLog(session.getClass());
        this.headerlog = LogFactory.getLog((String)"org.apache.synapse.transport.nhttp.headers");
        this.wirelog = LogFactory.getLog((String)"org.apache.synapse.transport.nhttp.wire");
        this.accesslog = LogFactory.getLog((String)"org.apache.synapse.transport.nhttp.access");
        this.id = "http-incoming-" + COUNT.incrementAndGet();
        if (this.iolog.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.session = new LoggingIOSession(session, this.id, this.iolog, this.wirelog);
        }
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Close connection"));
        }
        super.close();
    }

    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Shutdown connection"));
        }
        super.shutdown();
    }

    public void submitResponse(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": " + response.getStatusLine().toString()));
        }
        super.submitResponse(response);
    }

    public void consumeInput(NHttpServiceHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Consume input"));
        }
        super.consumeInput(handler);
    }

    public void produceOutput(NHttpServiceHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Produce output"));
        }
        super.produceOutput(handler);
    }

    protected NHttpMessageWriter<HttpResponse> createResponseWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter((NHttpMessageWriter<HttpResponse>)super.createResponseWriter(buffer, params));
    }

    protected NHttpMessageParser<HttpRequest> createRequestParser(SessionInputBuffer buffer, HttpRequestFactory requestFactory, HttpParams params) {
        return new LoggingNHttpMessageParser((NHttpMessageParser<HttpRequest>)super.createRequestParser(buffer, requestFactory, params));
    }

    public String toString() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingNHttpMessageParser
    implements NHttpMessageParser<HttpRequest> {
        private final NHttpMessageParser<HttpRequest> parser;

        public LoggingNHttpMessageParser(NHttpMessageParser<HttpRequest> parser) {
            this.parser = parser;
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpRequest parse() throws IOException, HttpException {
            HttpRequest message = (HttpRequest)this.parser.parse();
            if (message != null && LoggingNHttpServerConnection.this.headerlog.isDebugEnabled()) {
                LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " >> " + message.getRequestLine().toString()));
                Header[] headers = message.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " >> " + headers[i].toString()));
                }
            }
            if (message != null && LoggingNHttpServerConnection.this.accesslog.isInfoEnabled()) {
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            return message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter<HttpResponse> {
        private final NHttpMessageWriter<HttpResponse> writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter<HttpResponse> writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        public void write(HttpResponse message) throws IOException, HttpException {
            if (message != null && LoggingNHttpServerConnection.this.headerlog.isDebugEnabled()) {
                LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " << " + message.getStatusLine().toString()));
                Header[] headers = message.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " << " + headers[i].toString()));
                }
            }
            if (message != null && LoggingNHttpServerConnection.this.accesslog.isInfoEnabled()) {
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            this.writer.write((HttpMessage)message);
        }
    }
}

